/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.util.Comparator;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.joda.time.DateTime;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jboss.managed.ModeShapeManagedObject;

@Immutable
@ManagementObject(description="A ModeShape session", componentType=@ManagementComponent(type="ModeShape", subtype="Session"), properties=ManagementProperties.EXPLICIT)
public final class ManagedSession
implements ModeShapeManagedObject {
    public static final Comparator<ManagedSession> SORT_BY_USER = new Comparator<ManagedSession>(){

        @Override
        public int compare(ManagedSession thisSession, ManagedSession thatSession) {
            return thisSession.getUserName().compareTo(thatSession.getUserName());
        }
    };
    private final String id;
    private final DateTime timeCreated;
    private final String userName;
    private final String workspaceName;

    public ManagedSession(String workspaceName, String userName, String id, DateTime timeCreated) {
        CheckArg.isNotEmpty((String)workspaceName, (String)"workspaceName");
        CheckArg.isNotEmpty((String)userName, (String)"userName");
        CheckArg.isNotEmpty((String)id, (String)"id");
        CheckArg.isNotNull((Object)timeCreated, (String)"timeCreated");
        this.id = id;
        this.timeCreated = timeCreated;
        this.userName = userName;
        this.workspaceName = workspaceName;
    }

    @ManagementProperty(name="Session ID", description="The session's unique identifier", readOnly=true, use={ViewUse.RUNTIME})
    @ManagementObjectID(prefix="ModeShapeSession-")
    public String getId() {
        return this.id;
    }

    @ManagementProperty(name="Time Created", description="The time this session was created", readOnly=true, use={ViewUse.RUNTIME})
    public DateTime getTimeCreated() {
        return this.timeCreated;
    }

    @ManagementProperty(name="User Name", description="The name of the session's user", readOnly=true, use={ViewUse.RUNTIME})
    public String getUserName() {
        return this.userName;
    }

    @ManagementProperty(name="Workspace Name", description="The name of the workspace this session belongs to", readOnly=true, use={ViewUse.RUNTIME})
    public String getWorkspaceName() {
        return this.workspaceName;
    }
}

