/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventJournal;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.NetChangeObserver;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.PropertyChangeRequest;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeLexicon;

final class JcrObservationManager
implements ObservationManager {
    static final String OBSERVATION_USER_DATA_KEY = "org.modeshape.jcr.observation.userdata";
    static final String MOVE_FROM_KEY = "srcAbsPath";
    static final String MOVE_TO_KEY = "destAbsPath";
    static final String ORDER_CHILD_KEY = "srcChildRelPath";
    static final String ORDER_BEFORE_KEY = "destChildRelPath";
    private final Observable repositoryObservable;
    private final Map<EventListener, JcrListenerAdapter> listeners;
    private final NamespaceRegistry namespaceRegistry;
    private final JcrSession session;
    private final ValueFactories valueFactories;
    private final ValueFactory<String> stringFactory;
    private final String workspaceName;
    private final String systemWorkspaceName;
    private final String systemSourceName;

    JcrObservationManager(JcrSession session, Observable repositoryObservable) {
        CheckArg.isNotNull((Object)session, (String)"session");
        CheckArg.isNotNull((Object)repositoryObservable, (String)"repositoryObservable");
        this.session = session;
        this.repositoryObservable = repositoryObservable;
        this.listeners = new ConcurrentHashMap<EventListener, JcrListenerAdapter>();
        this.namespaceRegistry = this.session.getExecutionContext().getNamespaceRegistry();
        this.valueFactories = this.session.getExecutionContext().getValueFactories();
        this.stringFactory = this.valueFactories.getStringFactory();
        this.workspaceName = this.session.getWorkspace().getName();
        this.systemWorkspaceName = this.session.repository().getSystemWorkspaceName();
        this.systemSourceName = this.session.repository().getSystemSourceName();
    }

    public synchronized void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        CheckArg.isNotNull((Object)listener, (String)"listener");
        this.checkSession();
        JcrListenerAdapter adapter = new JcrListenerAdapter(listener, eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal);
        this.repositoryObservable.unregister((Observer)adapter);
        this.repositoryObservable.register((Observer)adapter);
        this.listeners.put(listener, adapter);
    }

    void checkSession() throws RepositoryException {
        this.session.checkLive();
    }

    NamespaceRegistry namespaceRegistry() {
        return this.namespaceRegistry;
    }

    final String stringFor(Path path) {
        return (String)this.stringFactory.create(path);
    }

    final String stringFor(Path.Segment segment) {
        return (String)this.stringFactory.create(segment);
    }

    final String stringFor(Name name) {
        return (String)this.stringFactory.create(name);
    }

    JcrNodeTypeManager getNodeTypeManager() throws RepositoryException {
        return (JcrNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
    }

    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        this.checkSession();
        return new JcrEventListenerIterator((Collection<EventListener>)this.listeners.keySet());
    }

    String getUserId() {
        return this.session.getUserID();
    }

    ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    Graph getGraph() {
        return ((JcrWorkspace)this.session.getWorkspace()).graph();
    }

    String getSessionId() {
        return this.session.sessionId();
    }

    final String getWorkspaceName() {
        return this.workspaceName;
    }

    final String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    final String getSystemSourceName() {
        return this.systemSourceName;
    }

    synchronized void removeAllEventListeners() {
        for (JcrListenerAdapter listener : this.listeners.values()) {
            assert (listener != null);
            this.repositoryObservable.unregister((Observer)listener);
        }
        this.listeners.clear();
    }

    public synchronized void removeEventListener(EventListener listener) throws RepositoryException {
        this.checkSession();
        CheckArg.isNotNull((Object)listener, (String)"listener");
        JcrListenerAdapter jcrListener = this.listeners.remove(listener);
        if (jcrListener != null) {
            this.repositoryObservable.unregister((Observer)jcrListener);
        }
    }

    public void setUserData(String userData) {
        this.session.setSessionData(OBSERVATION_USER_DATA_KEY, userData);
    }

    public EventJournal getEventJournal() {
        return null;
    }

    public EventJournal getEventJournal(int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName) {
        return null;
    }

    @NotThreadSafe
    class JcrListenerAdapter
    extends NetChangeObserver {
        private final String absPath;
        private Map<Location, Map<Name, Property>> propertiesByLocation;
        private final EventListener delegate;
        private final int eventTypes;
        private final boolean isDeep;
        private final String[] nodeTypeNames;
        private final boolean noLocal;
        private final String[] uuids;

        public JcrListenerAdapter(EventListener delegate, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) {
            assert (delegate != null);
            this.delegate = delegate;
            this.eventTypes = eventTypes;
            this.absPath = absPath;
            this.isDeep = isDeep;
            this.uuids = uuids;
            this.nodeTypeNames = nodeTypeNames;
            this.noLocal = noLocal;
        }

        private boolean acceptBasedOnEventSource(Changes changes) {
            if (this.noLocal) {
                return !JcrObservationManager.this.getSessionId().equals(changes.getContextId());
            }
            return true;
        }

        private boolean acceptBasedOnNodeTypeName(NetChangeObserver.NetChange change) {
            boolean accept = true;
            if (this.shouldCheckNodeType()) {
                ValueFactory stringFactory = JcrObservationManager.this.getValueFactories().getStringFactory();
                Path changePath = null;
                changePath = change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_ADDED, NetChangeObserver.ChangeType.NODE_REMOVED}) ? change.getPath().getParent() : change.getPath();
                Location parentLocation = Location.create((Path)changePath);
                Map<Name, Property> propMap = this.propertiesByLocation.get(parentLocation);
                assert (propMap != null);
                try {
                    String primaryTypeName = (String)stringFactory.create(propMap.get(org.modeshape.graph.JcrLexicon.PRIMARY_TYPE).getFirstValue());
                    String[] mixinNames = null;
                    if (propMap.get(org.modeshape.graph.JcrLexicon.MIXIN_TYPES) != null) {
                        mixinNames = (String[])stringFactory.create(propMap.get(org.modeshape.graph.JcrLexicon.MIXIN_TYPES).getValuesAsArray());
                    }
                    return JcrObservationManager.this.getNodeTypeManager().isDerivedFrom(this.nodeTypeNames, primaryTypeName, mixinNames);
                }
                catch (RepositoryException e) {
                    accept = false;
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Throwable)e, JcrI18n.cannotPerformNodeTypeCheck, new Object[]{propMap.get(org.modeshape.graph.JcrLexicon.PRIMARY_TYPE), propMap.get(org.modeshape.graph.JcrLexicon.MIXIN_TYPES), this.nodeTypeNames});
                }
            }
            return accept;
        }

        private boolean acceptBasedOnPath(NetChangeObserver.NetChange change) {
            if (this.absPath != null && this.absPath.length() != 0) {
                Path matchPath = (Path)JcrObservationManager.this.getValueFactories().getPathFactory().create(this.absPath);
                Path changePath = null;
                changePath = change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_ADDED, NetChangeObserver.ChangeType.NODE_REMOVED}) ? change.getPath().getParent() : change.getPath();
                if (this.isDeep) {
                    return matchPath.isAtOrAbove(changePath);
                }
                return matchPath.equals(changePath);
            }
            return true;
        }

        private boolean acceptBasedOnUuid(NetChangeObserver.NetChange change) {
            UUID matchUuid;
            boolean accept = true;
            if (this.uuids != null && this.uuids.length != 0 && (matchUuid = change.getLocation().getUuid()) != null) {
                accept = false;
                UuidFactory uuidFactory = JcrObservationManager.this.getValueFactories().getUuidFactory();
                for (String uuidText : this.uuids) {
                    if (uuidText == null || uuidText.length() == 0) continue;
                    try {
                        UUID testUuid = (UUID)uuidFactory.create(uuidText);
                        if (!matchUuid.equals(testUuid)) continue;
                        accept = true;
                        break;
                    }
                    catch (ValueFormatException e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error(JcrI18n.cannotCreateUuid, new Object[]{uuidText});
                    }
                }
            }
            return accept;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof JcrListenerAdapter) {
                return this.delegate == ((JcrListenerAdapter)((Object)obj)).delegate;
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(Changes changes) {
            if (!this.acceptBasedOnEventSource(changes)) {
                return;
            }
            try {
                if (this.shouldCheckNodeType()) {
                    ArrayList<Location> changedLocations = new ArrayList<Location>();
                    Location root = null;
                    for (ChangeRequest request : changes.getChangeRequests()) {
                        String changedWorkspaceName = request.changedWorkspace();
                        if (!JcrObservationManager.this.getWorkspaceName().equals(changedWorkspaceName) && !JcrObservationManager.this.getSystemWorkspaceName().equals(changedWorkspaceName) && !changes.getSourceName().equals(JcrObservationManager.this.getSystemSourceName())) continue;
                        Path changedPath = request.changedLocation().getPath();
                        if (!(request instanceof PropertyChangeRequest)) {
                            changedPath = changedPath.getParent();
                        }
                        Location location = Location.create((Path)changedPath);
                        if (root == null && changedPath.isRoot()) {
                            root = location;
                        }
                        changedLocations.add(location);
                    }
                    if (!changedLocations.isEmpty()) {
                        Graph graph = JcrObservationManager.this.getGraph();
                        this.propertiesByLocation = graph.getProperties(new Name[]{org.modeshape.graph.JcrLexicon.PRIMARY_TYPE, org.modeshape.graph.JcrLexicon.MIXIN_TYPES}).on(changedLocations);
                        if (root != null && !this.propertiesByLocation.containsKey(root)) {
                            Property primaryType = graph.getContext().getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.ROOT});
                            Map<Name, Property> props = Collections.singletonMap(primaryType.getName(), primaryType);
                            this.propertiesByLocation.put(root, props);
                        }
                    }
                }
                super.notify(changes);
            }
            finally {
                this.propertiesByLocation = null;
            }
        }

        protected void notify(NetChangeObserver.NetChanges netChanges) {
            ArrayList<Event> events = new ArrayList<Event>();
            String userData = (String)netChanges.getData().get(JcrObservationManager.OBSERVATION_USER_DATA_KEY);
            JcrEventBundle bundle = new JcrEventBundle(netChanges.getTimestamp(), netChanges.getUserName(), userData);
            for (NetChangeObserver.NetChange change : netChanges.getNetChanges()) {
                Path propertyPath;
                String id;
                String changedWorkspaceName = change.getRepositoryWorkspaceName();
                if (!JcrObservationManager.this.getWorkspaceName().equals(changedWorkspaceName) && !JcrObservationManager.this.getSystemWorkspaceName().equals(changedWorkspaceName) && !netChanges.getSourceName().equals(JcrObservationManager.this.getSystemSourceName()) || !this.acceptBasedOnNodeTypeName(change) || !this.acceptBasedOnPath(change) || !this.acceptBasedOnUuid(change)) continue;
                Path path = change.getPath();
                PathFactory pathFactory = JcrObservationManager.this.getValueFactories().getPathFactory();
                UUID uuid = change.getLocation().getUuid();
                String string = id = uuid != null ? uuid.toString() : null;
                if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_MOVED})) {
                    Location original = change.getOriginalLocation();
                    Path originalPath = original.getPath();
                    if ((this.eventTypes & 0x20) == 32) {
                        Location before = change.getMovedBefore();
                        boolean sameParent = !originalPath.isRoot() && !path.isRoot() && originalPath.getParent().equals(path.getParent());
                        HashMap<String, String> info = new HashMap<String, String>();
                        if (sameParent && change.isReorder()) {
                            info.put(JcrObservationManager.ORDER_CHILD_KEY, JcrObservationManager.this.stringFor(originalPath.getLastSegment()));
                            info.put(JcrObservationManager.ORDER_BEFORE_KEY, before != null ? JcrObservationManager.this.stringFor(before.getPath().getLastSegment()) : null);
                        } else {
                            info.put(JcrObservationManager.MOVE_FROM_KEY, JcrObservationManager.this.stringFor(originalPath));
                            info.put(JcrObservationManager.MOVE_TO_KEY, JcrObservationManager.this.stringFor(path));
                        }
                        info = Collections.unmodifiableMap(info);
                        events.add(new JcrMoveEvent(bundle, 32, JcrObservationManager.this.stringFor(path), id, info));
                    }
                    if ((this.eventTypes & 1) == 1) {
                        events.add(new JcrEvent(bundle, 1, JcrObservationManager.this.stringFor(path), id));
                    }
                    if ((this.eventTypes & 2) == 2) {
                        events.add(new JcrEvent(bundle, 2, JcrObservationManager.this.stringFor(originalPath), id));
                    }
                }
                if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_ADDED}) && (this.eventTypes & 1) == 1) {
                    events.add(new JcrEvent(bundle, 1, JcrObservationManager.this.stringFor(path), id));
                } else if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.NODE_REMOVED}) && (this.eventTypes & 2) == 2) {
                    events.add(new JcrEvent(bundle, 2, JcrObservationManager.this.stringFor(path), id));
                }
                if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.PROPERTY_CHANGED}) && (this.eventTypes & 0x10) == 16) {
                    for (Property property : change.getModifiedProperties()) {
                        propertyPath = pathFactory.create(path, JcrObservationManager.this.stringFor(property.getName()));
                        events.add(new JcrEvent(bundle, 16, JcrObservationManager.this.stringFor(propertyPath), id));
                    }
                }
                if (change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.PROPERTY_ADDED}) && (this.eventTypes & 4) == 4) {
                    for (Property property : change.getAddedProperties()) {
                        propertyPath = pathFactory.create(path, JcrObservationManager.this.stringFor(property.getName()));
                        events.add(new JcrEvent(bundle, 4, JcrObservationManager.this.stringFor(propertyPath), id));
                    }
                }
                if (!change.includes(new NetChangeObserver.ChangeType[]{NetChangeObserver.ChangeType.PROPERTY_REMOVED}) || (this.eventTypes & 8) != 8) continue;
                for (Name name : change.getRemovedProperties()) {
                    propertyPath = pathFactory.create(path, new Name[]{name});
                    events.add(new JcrEvent(bundle, 8, JcrObservationManager.this.stringFor(propertyPath), id));
                }
            }
            if (!events.isEmpty()) {
                this.delegate.onEvent((EventIterator)new JcrEventIterator((Collection<Event>)events));
            }
        }

        private boolean shouldCheckNodeType() {
            return this.nodeTypeNames != null && this.nodeTypeNames.length != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    class JcrMoveEvent
    extends JcrEvent {
        private final Map<String, String> info;

        public JcrMoveEvent(JcrEventBundle bundle, int type, String path, String id, Map<String, String> info) {
            super(bundle, type, path, id);
            this.info = info;
        }

        @Override
        public Map<String, String> getInfo() {
            return this.info;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node moved");
            String from = this.info.containsKey(JcrObservationManager.MOVE_FROM_KEY) ? this.info.get(JcrObservationManager.MOVE_FROM_KEY) : this.info.get(JcrObservationManager.ORDER_CHILD_KEY);
            String to = this.info.containsKey(JcrObservationManager.MOVE_TO_KEY) ? this.info.get(JcrObservationManager.MOVE_TO_KEY) : this.info.get(JcrObservationManager.ORDER_BEFORE_KEY);
            sb.append(" from ").append(from).append(" to ").append(to).append(" by ").append(this.getUserID());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    class JcrEvent
    implements Event {
        private final String id;
        private final String path;
        private final int type;
        private final JcrEventBundle bundle;

        public JcrEvent(JcrEventBundle bundle, int type, String path, String id) {
            this.type = type;
            this.path = path;
            this.bundle = bundle;
            this.id = id;
        }

        public String getPath() {
            return this.path;
        }

        public int getType() {
            return this.type;
        }

        public String getUserID() {
            return this.bundle.getUserID();
        }

        public long getDate() {
            return this.bundle.getDate().getMilliseconds();
        }

        public String getIdentifier() {
            return this.id;
        }

        public String getUserData() {
            return this.bundle.getUserData();
        }

        public Map<String, String> getInfo() {
            return Collections.emptyMap();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.type) {
                case 1: {
                    sb.append("Node added");
                    break;
                }
                case 2: {
                    sb.append("Node removed");
                    break;
                }
                case 4: {
                    sb.append("Property added");
                    break;
                }
                case 16: {
                    sb.append("Property changed");
                    break;
                }
                case 8: {
                    sb.append("Property removed");
                    break;
                }
                case 32: {
                    sb.append("Node moved");
                }
            }
            sb.append(" at ").append(this.path).append(" by ").append(this.getUserID());
            return sb.toString();
        }
    }

    @Immutable
    class JcrEventBundle {
        private final DateTime date;
        private final String userId;
        private final String userData;

        public JcrEventBundle(DateTime dateTime, String userId, String userData) {
            this.userId = userId;
            this.userData = userData;
            this.date = dateTime;
        }

        public String getUserID() {
            return this.userId;
        }

        public DateTime getDate() {
            return this.date;
        }

        public String getUserData() {
            return this.userData;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JcrEventIterator
    extends JcrRangeIterator<Event>
    implements EventIterator {
        public JcrEventIterator(Collection<Event> events) {
            super(events);
        }

        public Event nextEvent() {
            return (Event)this.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JcrEventListenerIterator
    extends JcrRangeIterator<EventListener>
    implements EventListenerIterator {
        public JcrEventListenerIterator(Collection<EventListener> listeners) {
            super(listeners);
        }

        public EventListener nextEventListener() {
            return (EventListener)this.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JcrRangeIterator<E>
    implements RangeIterator {
        private final List<? extends E> elements;
        private int position = 0;

        public JcrRangeIterator(Collection<? extends E> elements) {
            CheckArg.isNotNull(elements, (String)"elements");
            this.elements = new ArrayList<E>(elements);
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.elements.size();
        }

        public boolean hasNext() {
            return this.getPosition() < this.getSize();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E element = this.elements.get(this.position);
            ++this.position;
            return element;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void skip(long skipNum) {
            this.position = (int)((long)this.position + skipNum);
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
        }
    }
}

