/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.WebdavServlet;
import org.modeshape.common.util.Logger;
import org.modeshape.web.jcr.webdav.ContentMapper;
import org.modeshape.web.jcr.webdav.DefaultContentMapper;
import org.modeshape.web.jcr.webdav.ModeShapeWebdavStore;
import org.modeshape.web.jcr.webdav.MultiRepositoryRequestResolver;
import org.modeshape.web.jcr.webdav.RequestResolver;

public class ModeShapeWebdavServlet
extends WebdavServlet {
    private static final long serialVersionUID = 1L;
    public static final String INIT_CONTENT_MAPPER_CLASS_NAME = "org.modeshape.web.jcr.webdav.CONTENT_MAPPER_CLASS_NAME";
    public static final String INIT_REQUEST_RESOLVER_CLASS_NAME = "org.modeshape.web.jcr.webdav.REQUEST_RESOLVER_CLASS_NAME";
    private RequestResolver requestResolver;
    private ContentMapper contentMapper;

    protected IWebdavStore constructStore(String clazzName, File root) {
        return new ModeShapeWebdavStore(this.requestResolver, this.contentMapper);
    }

    protected String getParam(String name) {
        return this.getServletContext().getInitParameter(name);
    }

    private void constructRequestResolver() {
        String requestResolverClassName = this.getParam(INIT_REQUEST_RESOLVER_CLASS_NAME);
        Logger.getLogger(((Object)((Object)this)).getClass()).debug("WebDAV Servlet resolver class name = " + requestResolverClassName, new Object[0]);
        if (requestResolverClassName == null) {
            this.requestResolver = new MultiRepositoryRequestResolver();
        } else {
            try {
                Class<RequestResolver> clazz = Class.forName(requestResolverClassName).asSubclass(RequestResolver.class);
                this.requestResolver = clazz.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass()).debug("WebDAV Servlet using resolver class = " + this.requestResolver.getClass().getName(), new Object[0]);
        this.requestResolver.initialize(this.getServletContext());
    }

    private void constructContentMapper() {
        String contentMapperClassName = this.getParam(INIT_CONTENT_MAPPER_CLASS_NAME);
        Logger.getLogger(((Object)((Object)this)).getClass()).debug("WebDAV Servlet content mapper class name = " + contentMapperClassName, new Object[0]);
        if (contentMapperClassName == null) {
            this.contentMapper = new DefaultContentMapper();
        } else {
            try {
                Class<ContentMapper> clazz = Class.forName(contentMapperClassName).asSubclass(ContentMapper.class);
                this.contentMapper = clazz.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass()).debug("WebDAV Servlet using content mapper class = " + this.contentMapper.getClass().getName(), new Object[0]);
        this.contentMapper.initialize(this.getServletContext());
    }

    public void init() throws ServletException {
        this.constructRequestResolver();
        this.constructContentMapper();
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ModeShapeWebdavStore.setRequest(req);
        try {
            super.service(req, resp);
        }
        finally {
            ModeShapeWebdavStore.setRequest(null);
        }
    }
}

