/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.accessor.DataAccessorFactory;
import org.semanticdesktop.aperture.accessor.impl.DataAccessorRegistryImpl;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultDataAccessorRegistry
extends DataAccessorRegistryImpl {
    private static final String DEFAULT_FILE = "org/semanticdesktop/aperture/accessor/impl/defaults.xml";
    private static final String ACCESSOR_FACTORY_TAG = "dataAccessorFactory";
    private static final String NAME_TAG = "name";

    public DefaultDataAccessorRegistry() {
        try {
            InputStream inputStream = ResourceUtil.getInputStream(DEFAULT_FILE, DefaultDataAccessorRegistry.class);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            this.parse(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to parse org/semanticdesktop/aperture/accessor/impl/defaults.xml", iOException);
        }
    }

    public DefaultDataAccessorRegistry(InputStream inputStream) throws IOException {
        this.parse(inputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        try {
            SimpleSAXParser simpleSAXParser = new SimpleSAXParser();
            simpleSAXParser.setListener(new DataAccessorParser());
            simpleSAXParser.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException(sAXException.getMessage());
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    private class DataAccessorParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private boolean insideFactoryElement = false;

        private DataAccessorParser() {
        }

        public void startTag(String string, Map map, String string2) throws SAXException {
            if (DefaultDataAccessorRegistry.ACCESSOR_FACTORY_TAG.equals(string)) {
                this.insideFactoryElement = true;
            } else if (DefaultDataAccessorRegistry.NAME_TAG.equals(string) && this.insideFactoryElement && string2 != null) {
                this.processClassName(string2);
            }
        }

        public void endTag(String string) {
            if (DefaultDataAccessorRegistry.ACCESSOR_FACTORY_TAG.equals(string)) {
                this.insideFactoryElement = false;
            }
        }

        private void processClassName(String string) {
            if (!(string = string.trim()).equals("")) {
                try {
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    DataAccessorFactory dataAccessorFactory = (DataAccessorFactory)obj;
                    DefaultDataAccessorRegistry.this.add(dataAccessorFactory);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.warn("unable to find class " + string + ", ignoring", (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    this.logger.warn("unable to instantiate class " + string + ", ignoring", (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.warn("unable to access class " + string + ", ignoring", (Throwable)illegalAccessException);
                }
                catch (ClassCastException classCastException) {
                    this.logger.warn("unable to cast instance to " + DataAccessorFactory.class.getName() + ", ignoring", (Throwable)classCastException);
                }
            }
        }
    }
}

