/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.addressbook.thunderbird;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.addressbook.AddressbookCrawler;
import org.semanticdesktop.aperture.addressbook.thunderbird.ThunderbirdAddressbookDataSource;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.demork.Demork;
import org.semanticdesktop.demork.Utils;
import org.semanticdesktop.demork.database.Cell;
import org.semanticdesktop.demork.database.Database;
import org.semanticdesktop.demork.database.Row;
import org.semanticdesktop.demork.database.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThunderbirdCrawler
extends AddressbookCrawler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TYPE = "thunderbird";
    private static final String THUNDERBIRD_URI_BASE = "urn:thunderbird:";
    private static List<String> skipProperties = new Vector<String>();
    private Resource affiliationResource;
    private Resource organizationResource;

    public ThunderbirdCrawler(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public ThunderbirdCrawler() {
    }

    public List crawlAddressbook() throws Exception {
        String string = this.getAddressBookFile();
        if (string == null) {
            throw new NullPointerException("No thunderbirdAddressbookPath option set");
        }
        Demork demork = new Demork();
        String string2 = demork.getEncoding(string);
        String string3 = Utils.readWholeFileAsEncoding((String)string, (String)string2);
        Database database = demork.inputMork(string3);
        Vector<DataObject> vector = new Vector<DataObject>();
        for (String string4 : database.tables.keySet()) {
            Table table = (Table)database.tables.get(string4);
            for (String string5 : table.rows.keySet()) {
                DataObject dataObject = this.reportContact((Row)table.rows.get(string5));
                if (dataObject == null) continue;
                vector.add(dataObject);
            }
        }
        return vector;
    }

    public URI getContactListUri() {
        String string = this.getAddressBookFile();
        if (string == null) {
            return null;
        }
        File file = new File(string);
        try {
            return new URIImpl(file.toURI().toURL() + "#ThunderbirdContactList");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private String getAddressBookFile() {
        return ((ThunderbirdAddressbookDataSource)this.getDataSource()).getThunderbirdAddressbookPath();
    }

    private void addAffiliation(Resource resource, Model model) {
        if (this.affiliationResource == null && this.organizationResource == null) {
            this.affiliationResource = UriUtil.generateRandomResource(model);
            this.organizationResource = UriUtil.generateRandomResource(model);
            model.addStatement(this.affiliationResource, RDF.type, (Node)NCO.Affiliation);
            model.addStatement(this.organizationResource, RDF.type, (Node)NCO.OrganizationContact);
            model.addStatement(resource, NCO.hasAffiliation, (Node)this.affiliationResource);
            model.addStatement(this.affiliationResource, NCO.org, (Node)this.organizationResource);
        }
    }

    private DataObject reportContact(Row row) {
        Cell cell2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (Cell cell2 : row.cells) {
            if (skipProperties.contains(cell2.column) || cell2.atom.equals("")) continue;
            hashtable.put(cell2.column, cell2.atom);
        }
        if (hashtable.size() == 0) {
            return null;
        }
        String string = this.createURI(row.id);
        cell2 = URIImpl.createURIWithoutChecking((String)string);
        RDFContainerFactory rDFContainerFactory = this.getRDFContainerFactory(string);
        RDFContainer rDFContainer = rDFContainerFactory.getRDFContainer((URI)cell2);
        Model model = rDFContainer.getModel();
        rDFContainer.add(RDF.type, (Node)NCO.Contact);
        rDFContainer.add(RDF.type, (Node)NCO.ContactListDataObject);
        this.affiliationResource = null;
        this.organizationResource = null;
        for (String string2 : hashtable.keySet()) {
            String string3 = (String)hashtable.get(string2);
            try {
                Resource resource;
                if (string2.equals("PrimaryEmail")) {
                    resource = UriUtil.generateRandomResource(model);
                    model.addStatement(resource, RDF.type, (Node)NCO.EmailAddress);
                    model.addStatement(resource, NCO.emailAddress, string3);
                    model.addStatement(resource, NCO.contactMediumComment, "Primary Email");
                } else if (string2.equals("SecondEmail")) {
                    resource = UriUtil.generateRandomResource(model);
                    model.addStatement(resource, RDF.type, (Node)NCO.EmailAddress);
                    model.addStatement(resource, NCO.emailAddress, string3);
                    model.addStatement(resource, NCO.contactMediumComment, "Second Email");
                } else if (string2.equals("FirstName")) {
                    rDFContainer.add(NCO.nameGiven, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                    rDFContainer.add(RDF.type, (Node)NCO.PersonContact);
                } else if (string2.equals("LastName")) {
                    rDFContainer.add(NCO.nameFamily, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                    rDFContainer.add(RDF.type, (Node)NCO.PersonContact);
                } else if (string2.equals("DisplayName")) {
                    rDFContainer.add(RDFS.label, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                    rDFContainer.add(NCO.fullname, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                } else if (string2.equals("NickName")) {
                    rDFContainer.add(NCO.nickname, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                    rDFContainer.add(RDF.type, (Node)NCO.PersonContact);
                } else if (string2.equals("WorkPhone")) {
                    this.addAffiliation((Resource)cell2, model);
                    this.addPhoneNumber(this.affiliationResource, model, string3, null);
                } else if (string2.equals("HomePhone")) {
                    this.addPhoneNumber((Resource)cell2, model, string3, null);
                } else if (string2.equals("FaxNumber")) {
                    this.addPhoneNumber((Resource)cell2, model, string3, NCO.FaxNumber);
                } else if (string2.equals("PagerNumber")) {
                    this.addPhoneNumber((Resource)cell2, model, string3, NCO.PagerNumber);
                } else if (string2.equals("CellularNumber")) {
                    this.addPhoneNumber((Resource)cell2, model, string3, NCO.CellPhoneNumber);
                } else if (string2.equals("JobTitle")) {
                    this.addAffiliation((Resource)cell2, model);
                    model.addStatement(this.affiliationResource, NCO.title, string3);
                } else if (string2.equals("Department")) {
                    this.addAffiliation((Resource)cell2, model);
                    model.addStatement(this.affiliationResource, NCO.department, string3);
                } else if (string2.equals("Company")) {
                    this.addAffiliation((Resource)cell2, model);
                    model.addStatement(this.organizationResource, NCO.fullname, string3);
                } else if (string2.equals("_AimScreenName")) {
                    resource = UriUtil.generateRandomResource(model);
                    model.addStatement(resource, RDF.type, (Node)NCO.IMAccount);
                    model.addStatement(resource, NCO.imAccountType, "AIM");
                    model.addStatement(resource, NCO.imNickname, string3);
                    rDFContainer.add(NCO.hasIMAccount, (Node)resource);
                } else if (string2.equals("WebPage1")) {
                    rDFContainer.add(NCO.websiteUrl, string3);
                } else if (string2.equals("WebPage2")) {
                    rDFContainer.add(NCO.websiteUrl, string3);
                } else if (string2.equals("Custom1")) {
                    rDFContainer.add(NCO.note, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                } else if (string2.equals("Custom2")) {
                    rDFContainer.add(NCO.note, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                } else if (string2.equals("Custom3")) {
                    rDFContainer.add(NCO.note, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                } else if (string2.equals("Custom4")) {
                    rDFContainer.add(NCO.note, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                } else if (string2.equals("Notes")) {
                    rDFContainer.add(NCO.note, (Node)rDFContainer.getValueFactory().createLiteral(string3));
                }
                this.addAddress(hashtable, (Resource)cell2, model, "Home", NCO.hasPostalAddress);
                this.addAddress(hashtable, (Resource)cell2, model, "Work", NCO.hasPostalAddress);
                model.addStatement(model.createStatement((Resource)this.getContactListUri(), NCO.containsContact, (Node)cell2));
            }
            catch (ModelException modelException) {
                this.logger.error("ModelException while adding statements", (Throwable)modelException);
            }
        }
        DataObjectBase dataObjectBase = new DataObjectBase((URI)cell2, this.source, rDFContainer);
        return dataObjectBase;
    }

    private void addEmailAddress(Resource resource, Model model, String string, URI uRI, String string2) {
        Resource resource2 = UriUtil.generateRandomResource(model);
        if (uRI == null) {
            model.addStatement(resource2, RDF.type, (Node)NCO.EmailAddress);
        } else {
            model.addStatement(resource2, RDF.type, (Node)uRI);
        }
        model.addStatement(resource, NCO.hasEmailAddress, (Node)resource2);
        model.addStatement(resource2, NCO.emailAddress, string);
        if (string2 != null) {
            model.addStatement(resource2, NCO.contactMediumComment, string2);
        }
    }

    private void addPhoneNumber(Resource resource, Model model, String string, URI uRI) {
        Resource resource2 = UriUtil.generateRandomResource(model);
        if (uRI == null) {
            model.addStatement(resource2, RDF.type, (Node)NCO.PhoneNumber);
        } else {
            model.addStatement(resource2, RDF.type, (Node)uRI);
        }
        model.addStatement(resource, NCO.hasPhoneNumber, (Node)resource2);
        model.addStatement(resource2, NCO.phoneNumber, string);
    }

    private void addAddress(Hashtable hashtable, Resource resource, Model model, String string, URI uRI) throws ModelException {
        URI uRI2 = model.createURI(resource.toString() + "_" + string + "Address");
        boolean bl = false;
        if (hashtable.containsKey(string + "Address")) {
            bl = true;
            if (hashtable.containsKey(string + "Address2")) {
                PlainLiteral plainLiteral = model.createPlainLiteral((String)hashtable.get(string + "Address") + hashtable.get(string + "Address2"));
                model.addStatement((Resource)uRI2, NCO.streetAddress, (Node)plainLiteral);
            } else {
                PlainLiteral plainLiteral = model.createPlainLiteral((String)hashtable.get(string + "Address"));
                model.addStatement((Resource)uRI2, NCO.streetAddress, (Node)plainLiteral);
            }
        }
        if (hashtable.containsKey(string + "City")) {
            bl = true;
            model.addStatement((Resource)uRI2, NCO.locality, (String)hashtable.get(string + "City"));
        }
        if (hashtable.containsKey(string + "Country")) {
            bl = true;
            model.addStatement((Resource)uRI2, NCO.country, (String)hashtable.get(string + "Country"));
        }
        if (hashtable.containsKey(string + "State")) {
            bl = true;
            model.addStatement((Resource)uRI2, NCO.region, (String)hashtable.get(string + "State"));
        }
        if (hashtable.containsKey(string + "ZipCode")) {
            bl = true;
            model.addStatement((Resource)uRI2, NCO.postalcode, (String)hashtable.get(string + "ZipCode"));
        }
        if (bl) {
            model.addStatement((Resource)uRI2, RDF.type, (Node)NCO.PostalAddress);
            model.addStatement(resource, NCO.hasPostalAddress, (Node)uRI2);
        }
    }

    private String createURI(String string) {
        return "urn:thunderbird:Person:" + string;
    }

    private static String readWholeFile(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("utf-8").newDecoder());
        StringWriter stringWriter = new StringWriter(1024);
        char[] cArray = new char[1024];
        while (((Reader)inputStreamReader).ready() && (n = inputStreamReader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        ((Reader)inputStreamReader).close();
        stringWriter.close();
        return stringWriter.toString();
    }

    static {
        skipProperties.add("PreferMailFormat");
        skipProperties.add("PopularityIndex");
        skipProperties.add("RecordKey");
        skipProperties.add("LastModifiedData");
    }
}

