/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.imap;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Store;
import org.semanticdesktop.aperture.crawler.imap.ImapCrawler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImapStreamPool {
    private Logger logger = LoggerFactory.getLogger(ImapCrawler.class);
    private boolean closeRequested;
    private Store store;
    private Set<InputStream> streamSet;

    public ImapStreamPool(Store store) {
        this.store = store;
        this.closeRequested = false;
        this.streamSet = new HashSet<InputStream>();
    }

    public synchronized InputStream getStreamForAMessage(Part part) throws MessagingException, IOException {
        if (!this.store.isConnected()) {
            this.store.connect();
            this.closeRequested = false;
        }
        ImapInputStream imapInputStream = new ImapInputStream(part.getInputStream(), this);
        this.streamSet.add(imapInputStream);
        return imapInputStream;
    }

    public synchronized void requestClose() {
        this.closeRequested = true;
        if (this.streamSet.isEmpty()) {
            this.closeStore();
        }
    }

    private synchronized void notifyStreamClosed(InputStream inputStream) {
        if (this.streamSet.contains(inputStream)) {
            this.streamSet.remove(inputStream);
            if (this.closeRequested) {
                this.closeStore();
            }
        } else {
            this.logger.warn("Trying to return a stream that doesn't belong here");
        }
    }

    private void closeStore() {
        try {
            this.store.close();
        }
        catch (MessagingException messagingException) {
            this.logger.warn("Couldn't close the IMAP store", (Throwable)messagingException);
        }
    }

    private static class ImapInputStream
    extends InputStream {
        private InputStream stream;
        private ImapStreamPool pool;

        public ImapInputStream(InputStream inputStream, ImapStreamPool imapStreamPool) {
            this.pool = imapStreamPool;
            this.stream = inputStream;
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        public void close() throws IOException {
            this.pool.notifyStreamClosed(this);
            this.stream.close();
        }

        public boolean equals(Object object) {
            return this.stream.equals(object);
        }

        public int hashCode() {
            return this.stream.hashCode();
        }

        public void mark(int n) {
            this.stream.mark(n);
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.stream.read(byArray, n, n2);
        }

        public int read(byte[] byArray) throws IOException {
            return this.stream.read(byArray);
        }

        public void reset() throws IOException {
            this.stream.reset();
        }

        public long skip(long l) throws IOException {
            return this.stream.skip(l);
        }

        public String toString() {
            return this.stream.toString();
        }
    }
}

