/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.mail;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.FolderDataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.FolderDataObjectBase;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.crawler.mail.DataObjectFactory;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaMailCrawler
extends CrawlerBase
implements DataObjectFactory.PartStreamFactory {
    protected int maxDepth;
    protected long maximumByteSize;
    protected ArrayList baseFolders = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String cachedMessageUrl;
    private Map cachedDataObjectsMap = new HashMap();
    protected static final String ACCESSED_KEY = "accessed";
    protected Folder currentFolder;
    protected URI currentFolderURI;

    protected abstract URI getFolderURI(Folder var1) throws MessagingException;

    protected abstract String getMessageUri(Folder var1, Message var2) throws MessagingException;

    protected abstract boolean checkIfCurrentFolderHasBeenChanged(AccessData var1) throws MessagingException;

    protected abstract void recordCurrentFolderInAccessData(AccessData var1) throws MessagingException;

    protected void setCurrentFolder(Folder folder) throws MessagingException {
        this.currentFolder = folder;
        this.currentFolderURI = this.getFolderURI(folder);
    }

    protected Message getMessageFromCurrentFolder(int n) throws MessagingException {
        return this.currentFolder.getMessage(n);
    }

    protected int getCurrentFolderMessageCount() throws MessagingException {
        return this.currentFolder.getMessageCount();
    }

    public InputStream getPartStream(Part part) throws MessagingException, IOException {
        return part.getInputStream();
    }

    protected final void crawlFolder(Folder folder, int n) throws MessagingException {
        if (this.isStopRequested()) {
            return;
        }
        if (folder == null) {
            this.logger.debug("passed null folder, ignoring");
            return;
        }
        if (!folder.exists()) {
            this.logger.debug("folder does not exist: \"" + folder.getFullName() + "\"");
            return;
        }
        this.logger.debug("crawling folder \"" + folder.getFullName() + "\"");
        this.crawlSingleFolder(folder);
        if (AbstractJavaMailCrawler.holdsFolders(folder)) {
            this.logger.debug("crawling subfolders in folder \"" + folder.getFullName() + "\"");
            this.crawlSubFolders(folder, n);
        }
        if (folder.isOpen()) {
            folder.close(false);
        }
    }

    private void crawlSingleFolder(Folder folder) throws MessagingException {
        String string;
        if (AbstractJavaMailCrawler.holdsMessages(folder) && !folder.isOpen()) {
            folder.open(1);
        }
        if (!this.inDomain(string = this.getFolderURI(folder).toString())) {
            return;
        }
        this.setCurrentFolder(folder);
        this.reportAccessingObject(string);
        boolean bl = this.accessData == null ? false : this.accessData.isKnownId(string);
        RDFContainerFactory rDFContainerFactory = this.getRDFContainerFactory(string);
        try {
            FolderDataObject folderDataObject = this.getCurrentFolderObject(this.source, this.accessData, rDFContainerFactory);
            if (this.isStopRequested()) {
                return;
            }
            if (folderDataObject == null) {
                this.reportNotModified(string);
            } else {
                if (bl) {
                    this.reportModifiedDataObject(folderDataObject);
                } else {
                    this.reportNewDataObject(folderDataObject);
                }
                if (AbstractJavaMailCrawler.holdsMessages(folder)) {
                    this.crawlMessages(folder, folderDataObject.getID());
                }
            }
        }
        catch (MessagingException messagingException) {
            this.logger.warn("Exception while crawling folder " + string, (Throwable)messagingException);
        }
    }

    private void crawlSubFolders(Folder folder, int n) {
        if (n + 1 > this.maxDepth && this.maxDepth >= 0) {
            this.logger.debug("Reached crawling depth limit (" + this.maxDepth + ") - stopping.");
            return;
        }
        try {
            Folder[] folderArray = folder.list();
            this.logger.debug("Crawling " + folderArray.length + " sub-folders.");
            for (int i = 0; !this.isStopRequested() && i < folderArray.length; ++i) {
                try {
                    this.crawlFolder(folderArray[i], n + 1);
                    continue;
                }
                catch (MessagingException messagingException) {
                    this.logger.debug("Error crawling subfolder \"" + folderArray[i].getFullName() + "\"");
                }
            }
        }
        catch (MessagingException messagingException) {
            this.logger.warn("Exception while crawling subFolders of \"" + folder.getFullName() + "\"", (Throwable)messagingException);
        }
    }

    private void crawlMessages(Folder folder, URI uRI) throws MessagingException {
        if (this.isStopRequested()) {
            return;
        }
        this.logger.debug("Crawling messages in folder " + folder.getFullName());
        int n = this.getCurrentFolderMessageCount();
        for (int i = 1; i <= n && !this.isStopRequested(); ++i) {
            MimeMessage mimeMessage = (MimeMessage)this.getMessageFromCurrentFolder(i);
            String string = this.getMessageUri(folder, (Message)mimeMessage);
            try {
                if (!this.inDomain(string)) continue;
                this.crawlMessage(mimeMessage, string, uRI);
                continue;
            }
            catch (Exception exception) {
                this.logger.warn("Exception while crawling message " + string, (Throwable)exception);
            }
        }
    }

    private void crawlMessage(MimeMessage mimeMessage, String string, URI uRI) throws MessagingException {
        if (!this.isAcceptable((Message)mimeMessage)) {
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        while (!linkedList.isEmpty()) {
            String string2 = (String)linkedList.removeFirst();
            this.reportAccessingObject(string2);
            RDFContainerFactory rDFContainerFactory = this.getRDFContainerFactory(string2);
            try {
                DataObject dataObject = this.getObject(mimeMessage, string2, uRI, this.source, this.accessData, rDFContainerFactory);
                if (dataObject == null) {
                    this.reportNotModified(string2);
                    continue;
                }
                this.queueChildren(dataObject, linkedList);
                this.registerParent(dataObject);
                dataObject.getMetadata().add(NIE.isPartOf, (Node)uRI);
                this.reportNewDataObject(dataObject);
            }
            catch (MessagingException messagingException) {
                this.logger.warn("MessagingException while processing " + string2, (Throwable)messagingException);
            }
            catch (UrlNotFoundException urlNotFoundException) {
                this.logger.error("Internal error while processing " + string2, (Throwable)urlNotFoundException);
            }
            catch (IOException iOException) {
                this.logger.warn("IOException while processing " + string2, (Throwable)iOException);
            }
        }
        this.cachedDataObjectsMap.clear();
        this.cachedMessageUrl = null;
    }

    protected DataObject getObject(MimeMessage mimeMessage, String string, URI uRI, DataSource dataSource, AccessData accessData, RDFContainerFactory rDFContainerFactory) throws MessagingException, IOException {
        Object object;
        if (accessData != null && accessData.get(string, ACCESSED_KEY) != null) {
            return null;
        }
        String string2 = string;
        int n = string2.indexOf(35);
        if (n == 0) {
            string2 = "";
        } else if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (!string2.equals(this.cachedMessageUrl)) {
            this.cachedMessageUrl = null;
            this.cachedDataObjectsMap.clear();
            object = new DataObjectFactory();
            List list = ((DataObjectFactory)object).createDataObjects(mimeMessage, string2, uRI, dataSource, rDFContainerFactory, this);
            for (DataObject dataObject : list) {
                this.cachedDataObjectsMap.put(dataObject.getID().toString(), dataObject);
            }
            this.cachedMessageUrl = string2;
        }
        if ((object = (DataObject)this.cachedDataObjectsMap.get(string)) == null) {
            throw new UrlNotFoundException(string);
        }
        if (accessData != null) {
            accessData.put(string, ACCESSED_KEY, "");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueChildren(DataObject dataObject, LinkedList linkedList) {
        Model model = dataObject.getMetadata().getModel();
        ClosableIterator closableIterator = null;
        try {
            closableIterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)NIE.isPartOf, (NodeOrVariable)dataObject.getID());
            while (closableIterator.hasNext()) {
                Statement statement = (Statement)closableIterator.next();
                Resource resource = statement.getSubject();
                if (resource instanceof URI) {
                    String string = resource.toString();
                    if (linkedList.contains(string)) continue;
                    linkedList.add(string);
                    continue;
                }
                this.logger.error("Internal error: unknown child value type: " + resource.getClass());
            }
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("Couldn't queue children", (Throwable)modelRuntimeException);
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
    }

    private void registerParent(DataObject dataObject) {
        if (this.accessData == null) {
            return;
        }
        URI uRI = this.getParent(dataObject);
        if (uRI != null) {
            String string = uRI.toString();
            String string2 = dataObject.getID().toString();
            if (this.accessData.isKnownId(string)) {
                if (string.equals(string2)) {
                    this.logger.error("cyclical " + NIE.isPartOf + " property for " + string + ", ignoring");
                } else {
                    this.accessData.putReferredID(string, string2);
                }
            } else {
                this.logger.error("Internal error: encountered unknown parent: " + string + ", child = " + string2);
            }
        }
    }

    private URI getParent(DataObject dataObject) {
        HashSet hashSet = dataObject.getMetadata().getAll(NIE.isPartOf);
        if (!(hashSet instanceof Set)) {
            hashSet = new HashSet(hashSet);
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        if (hashSet.size() > 1) {
            this.logger.warn("Multiple parents for " + dataObject.getID() + ", ignoring all");
            return null;
        }
        Node node = (Node)hashSet.iterator().next();
        if (node instanceof URI) {
            return (URI)node;
        }
        this.logger.error("Internal error: encountered unexpected parent type: " + node.getClass());
        return null;
    }

    protected FolderDataObject getCurrentFolderObject(DataSource dataSource, AccessData accessData, RDFContainerFactory rDFContainerFactory) throws MessagingException {
        MimeMessage mimeMessage;
        int n;
        boolean bl = this.checkIfCurrentFolderHasBeenChanged(accessData);
        if (!bl && accessData != null) {
            return null;
        }
        RDFContainer rDFContainer = rDFContainerFactory.getRDFContainer(this.currentFolderURI);
        rDFContainer.add(NIE.title, this.currentFolder.getName());
        Folder folder = this.currentFolder.getParent();
        if (folder != null) {
            rDFContainer.add(NIE.isPartOf, (Node)this.getFolderURI(folder));
            rDFContainer.getModel().addStatement((Resource)this.getFolderURI(folder), RDF.type, (Node)NFO.Folder);
        }
        if (AbstractJavaMailCrawler.holdsMessages(this.currentFolder)) {
            int n2 = this.getCurrentFolderMessageCount();
            for (n = 1; n <= n2; ++n) {
                mimeMessage = (MimeMessage)this.getMessageFromCurrentFolder(n);
                if (!this.isAcceptable((Message)mimeMessage)) continue;
                try {
                    URI uRI = rDFContainer.getModel().createURI(this.getMessageUri(this.currentFolder, (Message)mimeMessage));
                    rDFContainer.getModel().addStatement((Resource)uRI, NIE.isPartOf, (Node)this.currentFolderURI);
                    rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)NMO.MailboxDataObject);
                    continue;
                }
                catch (ModelRuntimeException modelRuntimeException) {
                    this.logger.error("ModelException while creating URI", (Throwable)modelRuntimeException);
                }
            }
        }
        Folder[] folderArray = this.currentFolder.list();
        for (n = 0; n < folderArray.length; ++n) {
            mimeMessage = folderArray[n];
            if (!mimeMessage.exists()) continue;
            rDFContainer.add(rDFContainer.getValueFactory().createStatement((Resource)this.getFolderURI((Folder)mimeMessage), NIE.isPartOf, (Node)this.currentFolderURI));
        }
        this.recordCurrentFolderInAccessData(accessData);
        if (this.baseFolders.contains(this.currentFolder.getFullName())) {
            rDFContainer.add(NIE.rootElementOf, (Node)dataSource.getID());
        }
        return new FolderDataObjectBase(this.currentFolderURI, dataSource, rDFContainer);
    }

    protected long getMessageUid(Folder folder, Message message) throws MessagingException {
        if (folder instanceof UIDFolder) {
            return ((UIDFolder)folder).getUID(message);
        }
        return -1L;
    }

    protected int getMessageCount(Message[] messageArray) throws MessagingException {
        int n = 0;
        for (int i = 0; i < messageArray.length; ++i) {
            Message message = messageArray[i];
            if (this.isRemoved(message)) continue;
            ++n;
        }
        return n;
    }

    protected String getSubFoldersString(Folder folder) throws MessagingException {
        StringBuilder stringBuilder = new StringBuilder();
        Folder[] folderArray = folder.list();
        for (int i = 0; i < folderArray.length; ++i) {
            Folder folder2 = folderArray[i];
            if (!folder2.exists()) continue;
            stringBuilder.append(folder2.getFullName());
            if (i >= folderArray.length - 1) continue;
            stringBuilder.append('@');
        }
        return stringBuilder.toString();
    }

    protected void reportNotModified(String string) {
        this.reportUnmodifiedDataObject(string);
        if (this.accessData == null) {
            this.logger.error("Internal error: reporting unmodified uri while no AccessData is set: " + string);
        } else {
            Set set = this.accessData.getReferredIDs(string);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.reportNotModified((String)iterator.next());
                }
            }
        }
    }

    protected boolean isRemoved(Message message) throws MessagingException {
        return message.isExpunged() || message.isSet(Flags.Flag.DELETED);
    }

    protected boolean isTooLarge(Message message) throws MessagingException {
        return (long)message.getSize() > this.maximumByteSize;
    }

    protected boolean isAcceptable(Message message) throws MessagingException {
        return !this.isRemoved(message) && !this.isTooLarge(message);
    }

    public static boolean holdsFolders(Folder folder) throws MessagingException {
        return (folder.getType() & 2) == 2;
    }

    public static boolean holdsMessages(Folder folder) throws MessagingException {
        return (folder.getType() & 1) == 1;
    }
}

