/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.presentations;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.util.PoiUtil;
import org.semanticdesktop.aperture.extractor.util.WPStringExtractor;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresentationsExtractor
implements Extractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final byte[] OFFICE_MAGIC_BYTES = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] WORDPERFECT_MAGIC_BYTES = new byte[]{-1, 87, 80, 67};

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        try {
            PresentationsWPStringExtractor presentationsWPStringExtractor;
            String string2;
            int n = Math.max(OFFICE_MAGIC_BYTES.length, WORDPERFECT_MAGIC_BYTES.length);
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream, n);
            }
            inputStream.mark(n);
            byte[] byArray = IOUtil.readBytes(inputStream, n);
            inputStream.reset();
            if (this.hasMagicNumber(byArray, OFFICE_MAGIC_BYTES)) {
                inputStream = PoiUtil.extractAll(inputStream, null, rDFContainer, this.logger);
            } else if (this.hasMagicNumber(byArray, WORDPERFECT_MAGIC_BYTES) && (string2 = (presentationsWPStringExtractor = new PresentationsWPStringExtractor()).extract(inputStream).trim()).length() > 0) {
                rDFContainer.add(NIE.plainTextContent, string2);
            }
            rDFContainer.add(RDF.type, (Node)NFO.Presentation);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
    }

    private boolean hasMagicNumber(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static class PresentationsWPStringExtractor
    extends WPStringExtractor {
        private static final String[] EXCLUDES = new String[]{"title of show", "subtitle of show", "subitem", "first item", "second item", "third item", "fourth item", "title of slide", "subtitle of slide", "north", "south", "east", "west", "this is the first item.  this is the second item.", "this is the third item.  this is the fourth item.", "click to edit master title style", "click to edit master subtitle", "click to edit master text styles", "footer area", "first level", "second level", "third level", "fourth level", "fifth level"};

        private PresentationsWPStringExtractor() {
        }

        protected boolean isValidLine(String string) {
            for (int i = 0; i < EXCLUDES.length; ++i) {
                if (!string.equals(EXCLUDES[i])) continue;
                return false;
            }
            return super.isValidLine(string);
        }
    }
}

