/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtfExtractor
implements Extractor {
    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        RTFEditorKit rTFEditorKit = new RTFEditorKit();
        Document document = rTFEditorKit.createDefaultDocument();
        try {
            rTFEditorKit.read(inputStream, document, 0);
            String string2 = document.getText(0, document.getLength());
            rDFContainer.add(NIE.plainTextContent, string2);
            rDFContainer.add(RDF.type, (Node)NFO.TextDocument);
        }
        catch (BadLocationException badLocationException) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.warn("Bad RTF location", (Throwable)badLocationException);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
    }
}

