/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.util;

import java.io.IOException;
import java.io.InputStream;
import org.semanticdesktop.aperture.extractor.util.StringExtractor;
import org.semanticdesktop.aperture.extractor.util.WPFilterInputStream;

public class WPStringExtractor
extends StringExtractor {
    private static final String[] EXACT_START_LINES = new String[]{"doc init", "tech init"};
    private static final String[] START_EXCLUDES = new String[]{"wpc", "monotype sorts", "section", "columns", "aligned ", "standard", "default ", "biblio", "footnote", "gfootnote", "endnote", "heading", "header for ", "underlined heading", "centered heading", "technical", "object #", "microsoft word"};
    private static final String[] END_EXCLUDES = new String[]{"aligned paragraph numbers", "heading", "bullet list"};
    private static final String[] EXACT_EXCLUDES = new String[]{"nlus.", "usjp", "initialize technical style", "document style", "pleading", "times", "and", "where", "left", "right", "over", "(k over", "document", "header", "footer", "itemize", "page number", "pages", "body text", "word", "sjablone", "d printer"};
    private static final String[] CONTAIN_EXCLUDES = new String[]{"left (", "right )", "right ]", "right par", "default paragraph"};

    public String extract(InputStream inputStream) throws IOException {
        return super.extract(new WPFilterInputStream(inputStream));
    }

    protected boolean isTextCharacter(int n) {
        return super.isTextCharacter(n) || n >= 192 && n <= 255 || n == 145 || n == 146;
    }

    protected boolean isStartLine(String string) {
        for (int i = 0; i < EXACT_START_LINES.length; ++i) {
            if (!string.equals(EXACT_START_LINES[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidLine(String string) {
        int n;
        for (n = 0; n < EXACT_EXCLUDES.length; ++n) {
            if (!string.equals(EXACT_EXCLUDES[n])) continue;
            return false;
        }
        for (n = 0; n < START_EXCLUDES.length; ++n) {
            if (!string.startsWith(START_EXCLUDES[n])) continue;
            return false;
        }
        for (n = 0; n < END_EXCLUDES.length; ++n) {
            if (!string.endsWith(END_EXCLUDES[n])) continue;
            return false;
        }
        for (n = 0; n < CONTAIN_EXCLUDES.length; ++n) {
            if (string.indexOf(CONTAIN_EXCLUDES[n]) < 0) continue;
            return false;
        }
        return super.isValidLine(string);
    }
}

