/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.hypertext.linkextractor.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.hypertext.linkextractor.LinkExtractorFactory;
import org.semanticdesktop.aperture.hypertext.linkextractor.impl.LinkExtractorRegistryImpl;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultLinkExtractorRegistry
extends LinkExtractorRegistryImpl {
    private static final String DEFAULT_FILE = "org/semanticdesktop/aperture/hypertext/linkextractor/impl/defaults.xml";
    private static final String SOURCE_FACTORY_TAG = "linkExtractorFactory";
    private static final String NAME_TAG = "name";

    public DefaultLinkExtractorRegistry() {
        try {
            InputStream inputStream = ResourceUtil.getInputStream(DEFAULT_FILE, DefaultLinkExtractorRegistry.class);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            this.parse(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to parse org/semanticdesktop/aperture/hypertext/linkextractor/impl/defaults.xml", iOException);
        }
    }

    public DefaultLinkExtractorRegistry(InputStream inputStream) throws IOException {
        this.parse(inputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        try {
            SimpleSAXParser simpleSAXParser = new SimpleSAXParser();
            simpleSAXParser.setListener(new LinkExtractorParser());
            simpleSAXParser.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException(sAXException.getMessage());
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    private class LinkExtractorParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private boolean insideFactoryElement = false;

        private LinkExtractorParser() {
        }

        public void startTag(String string, Map map, String string2) throws SAXException {
            if (DefaultLinkExtractorRegistry.SOURCE_FACTORY_TAG.equals(string)) {
                this.insideFactoryElement = true;
            } else if (DefaultLinkExtractorRegistry.NAME_TAG.equals(string) && this.insideFactoryElement && string2 != null) {
                this.processClassName(string2);
            }
        }

        public void endTag(String string) {
            if (DefaultLinkExtractorRegistry.SOURCE_FACTORY_TAG.equals(string)) {
                this.insideFactoryElement = false;
            }
        }

        private void processClassName(String string) {
            if (!(string = string.trim()).equals("")) {
                try {
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    LinkExtractorFactory linkExtractorFactory = (LinkExtractorFactory)obj;
                    DefaultLinkExtractorRegistry.this.add(linkExtractorFactory);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.warn("unable to find class " + string + ", ignoring", (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    this.logger.warn("unable to instantiate class " + string + ", ignoring", (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.warn("unable to access class " + string + ", ignoring", (Throwable)illegalAccessException);
                }
                catch (ClassCastException classCastException) {
                    this.logger.warn("unable to cast instance to " + LinkExtractorFactory.class.getName() + ", ignoring", (Throwable)classCastException);
                }
            }
        }
    }
}

