/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.hypertext.linkextractor.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticdesktop.aperture.hypertext.linkextractor.LinkExtractorFactory;
import org.semanticdesktop.aperture.hypertext.linkextractor.LinkExtractorRegistry;

public class LinkExtractorRegistryImpl
implements LinkExtractorRegistry {
    private HashMap factories = new HashMap();

    public void add(LinkExtractorFactory linkExtractorFactory) {
        if (linkExtractorFactory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String string : linkExtractorFactory.getSupportedMimeTypes()) {
            HashSet<LinkExtractorFactory> hashSet = (HashSet<LinkExtractorFactory>)this.factories.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<LinkExtractorFactory>();
                this.factories.put(string, hashSet);
            }
            hashSet.add(linkExtractorFactory);
        }
    }

    public void remove(LinkExtractorFactory linkExtractorFactory) {
        for (String string : linkExtractorFactory.getSupportedMimeTypes()) {
            Set set = (Set)this.factories.get(string);
            if (set == null) continue;
            set.remove(linkExtractorFactory);
            if (!set.isEmpty()) continue;
            this.factories.remove(string);
        }
    }

    public Set getAll() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.factories.values().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll((Set)iterator.next());
        }
        return hashSet;
    }

    public Set get(String string) {
        Set set = (Set)this.factories.get(string);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(set);
    }
}

