/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.magic;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.mime.identifier.MimeTypeIdentifier;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicNumber;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicString;
import org.semanticdesktop.aperture.mime.identifier.magic.MimeTypeDescription;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.UtfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MagicMimeTypeIdentifier
implements MimeTypeIdentifier {
    private static final String MIME_TYPES_RESOURCE = "org/semanticdesktop/aperture/mime/identifier/magic/mimetypes.xml";
    private static final int PLAIN_TEXT_TEST_ARRAY_LENGTH = 100;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ArrayList mimeTypeDescriptions;
    private int minArrayLength;

    public MagicMimeTypeIdentifier() {
        this(MIME_TYPES_RESOURCE);
    }

    public MagicMimeTypeIdentifier(String string) {
        this.readDescriptions(string);
        this.setRequiringTypes();
        this.determineMinArrayLength();
    }

    private void readDescriptions(String string) {
        Document document;
        DocumentBuilder documentBuilder;
        InputStream inputStream = ResourceUtil.getInputStream(string, MagicMimeTypeIdentifier.class);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setExpandEntityReferences(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("unable to instantiate DocumentBuilder", parserConfigurationException);
        }
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("description");
        int n = nodeList.getLength();
        this.mimeTypeDescriptions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            MimeTypeDescription mimeTypeDescription = this.createMimeTypeDescription(element2);
            if (mimeTypeDescription == null) continue;
            this.mimeTypeDescriptions.add(mimeTypeDescription);
        }
    }

    private MimeTypeDescription createMimeTypeDescription(Element element) {
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string3;
            Node node;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string4 = node2.getNodeName();
            if ("mimeType".equals(string4) && (node = node2.getFirstChild()) != null) {
                string = node.getNodeValue().trim();
            }
            if ("parentType".equals(string4)) {
                node = node2.getFirstChild();
                if (node == null) continue;
                string2 = node.getNodeValue().trim();
                continue;
            }
            if ("extensions".equals(string4)) {
                node = node2.getFirstChild();
                if (node == null) continue;
                string3 = node.getNodeValue().trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ", ", false);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken().toLowerCase());
                }
                continue;
            }
            if ("allowsLeadingWhiteSpace".equals(string4)) {
                node = node2.getFirstChild();
                if (node == null) continue;
                string3 = node.getNodeValue().trim();
                bl = Boolean.parseBoolean(string3);
                continue;
            }
            if ("magicNumber".equals(string4)) {
                this.createMagicNumber((Element)node2, string, arrayList3);
                continue;
            }
            if (!"magicString".equals(string4)) continue;
            this.createMagicString((Element)node2, string, arrayList2, arrayList3);
        }
        if (string == null) {
            return null;
        }
        return new MimeTypeDescription(string, string2, arrayList, arrayList2, arrayList3, bl);
    }

    private void createMagicNumber(Element element, String string, ArrayList arrayList) {
        byte[] byArray = null;
        Node node = element.getFirstChild();
        if (node == null) {
            this.logger.warn("missing magicNumber content in " + string + " description");
            return;
        }
        String string2 = node.getNodeValue();
        String string3 = element.getAttribute("encoding").trim();
        String string4 = element.getAttribute("offset").trim();
        int n = 0;
        if (string4.length() > 0) {
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warn("illegal offset: " + string4 + ", ignoring magic number");
                return;
            }
        }
        if ("string".equals(string3)) {
            try {
                byArray = string2.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        } else if ("hex".equals(string3)) {
            string2 = string2.trim();
            string2 = string2.replaceAll(" ", "");
            string2 = string2.toLowerCase();
            int n2 = string2.length();
            byArray = new byte[n2 / 2];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                int n4 = 0;
                if (c >= '0' && c <= '9') {
                    n4 = c - 48;
                } else if (c >= 'a' && c <= 'f') {
                    n4 = c - 97 + 10;
                } else {
                    this.logger.warn("illegal hexadecimal char: " + c);
                    return;
                }
                if (i % 2 == 0) {
                    n3 = 16 * n4;
                    continue;
                }
                byArray[i / 2] = (byte)(n3 += n4);
            }
        } else {
            this.logger.warn("unknown or empty encoding: " + string3);
            return;
        }
        arrayList.add(new MagicNumber(byArray, n));
    }

    private void createMagicString(Element element, String string, ArrayList arrayList, ArrayList arrayList2) {
        Node node = element.getFirstChild();
        if (node == null) {
            this.logger.warn("missing magicString content in " + string + " description");
            return;
        }
        String string2 = node.getNodeValue();
        arrayList.add(new MagicString(string2.toCharArray()));
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            byte[] byArray2 = UtfUtil.findMatchingBOM(byArray);
            if (byArray2 != null) {
                int n = byArray.length - byArray2.length;
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, byArray2.length, byArray3, 0, n);
                byArray = byArray3;
            }
            arrayList2.add(new MagicNumber(byArray, 0));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private void setRequiringTypes() {
        MimeTypeDescription mimeTypeDescription;
        HashMap<String, MimeTypeDescription> hashMap = new HashMap<String, MimeTypeDescription>();
        int n = this.mimeTypeDescriptions.size();
        for (int i = 0; i < n; ++i) {
            mimeTypeDescription = (MimeTypeDescription)this.mimeTypeDescriptions.get(i);
            hashMap.put(mimeTypeDescription.getMimeType(), mimeTypeDescription);
        }
        Iterator iterator = this.mimeTypeDescriptions.iterator();
        while (iterator.hasNext()) {
            mimeTypeDescription = (MimeTypeDescription)iterator.next();
            String string = mimeTypeDescription.getParentType();
            if (string == null) continue;
            iterator.remove();
            MimeTypeDescription mimeTypeDescription2 = (MimeTypeDescription)hashMap.get(string);
            if (mimeTypeDescription2 == null) {
                this.logger.warn("unable to retrieve parent type description for " + mimeTypeDescription.getMimeType());
                continue;
            }
            mimeTypeDescription2.addRequiringType(mimeTypeDescription);
        }
    }

    private void determineMinArrayLength() {
        this.minArrayLength = 100;
        int n = this.mimeTypeDescriptions.size();
        for (int i = 0; i < n; ++i) {
            MimeTypeDescription mimeTypeDescription = (MimeTypeDescription)this.mimeTypeDescriptions.get(i);
            ArrayList arrayList = mimeTypeDescription.getMagicNumbers();
            int n2 = arrayList.size();
            for (int j = 0; j < n2; ++j) {
                MagicNumber magicNumber = (MagicNumber)arrayList.get(j);
                this.minArrayLength = Math.max(this.minArrayLength, magicNumber.getMinimumLength());
            }
            ArrayList arrayList2 = mimeTypeDescription.getMagicStrings();
            int n3 = arrayList2.size();
            for (int j = 0; j < n3; ++j) {
                MagicString magicString = (MagicString)arrayList2.get(j);
                this.minArrayLength = Math.max(this.minArrayLength, magicString.getMinimumLength() * 2 + 2);
            }
        }
    }

    protected ArrayList getMimeTypeDescriptions() {
        return this.mimeTypeDescriptions;
    }

    public String identify(byte[] byArray, String string, URI uRI) {
        String string2;
        Object object;
        char[] cArray = null;
        byte[] byArray2 = null;
        if (byArray != null && (byArray2 = UtfUtil.findMatchingBOM(byArray)) != null) {
            int n = byArray.length - byArray2.length;
            object = new byte[n];
            System.arraycopy(byArray, byArray2.length, object, 0, n);
            byArray = object;
            String string3 = UtfUtil.getCharsetName(byArray2);
            if (string3 != null) {
                try {
                    String string4 = new String(byArray, string3);
                    cArray = string4.toCharArray();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if ((string2 = string) == null && uRI != null) {
            string2 = uRI.toString();
            string2 = this.removeFragment('?', string2);
            string2 = this.removeFragment('#', string2);
        }
        if (string2 != null) {
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string2 = string2.substring(n + 1);
            }
            string2 = string2.toLowerCase();
        }
        if ((object = (Object)this.identify(cArray, byArray, string2, this.mimeTypeDescriptions)) == null && byArray2 != null) {
            return "text/plain";
        }
        if (object == null && this.isReadableASCII(byArray)) {
            return "text/plain";
        }
        return object;
    }

    private String removeFragment(char c, String string) {
        int n;
        String string2 = string;
        if (string != null && (n = string.indexOf(c)) >= 0 && n < string.length() - 1) {
            return string.substring(0, n);
        }
        return string2;
    }

    private String identify(char[] cArray, byte[] byArray, String string, ArrayList arrayList) {
        MimeTypeDescription mimeTypeDescription;
        int n;
        int n2;
        if (cArray != null) {
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                mimeTypeDescription = (MimeTypeDescription)arrayList.get(n);
                if (!mimeTypeDescription.matches(cArray)) continue;
                ArrayList arrayList2 = mimeTypeDescription.getRequiringTypes();
                String string2 = this.identify(cArray, byArray, string, arrayList2);
                return string2 == null ? mimeTypeDescription.getMimeType() : string2;
            }
        }
        if (byArray != null) {
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                mimeTypeDescription = (MimeTypeDescription)arrayList.get(n);
                if (!mimeTypeDescription.matches(byArray)) continue;
                ArrayList arrayList3 = mimeTypeDescription.getRequiringTypes();
                String string3 = this.identify(cArray, byArray, string, arrayList3);
                return string3 == null ? mimeTypeDescription.getMimeType() : string3;
            }
        }
        if (string != null) {
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                mimeTypeDescription = (MimeTypeDescription)arrayList.get(n);
                if (!mimeTypeDescription.containsExtension(string)) continue;
                return mimeTypeDescription.getMimeType();
            }
        }
        return null;
    }

    public int getMinArrayLength() {
        return this.minArrayLength;
    }

    public List getExtensionsFor(String string) {
        return this.getExtensionsFor(string, this.mimeTypeDescriptions);
    }

    private List getExtensionsFor(String string, ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            MimeTypeDescription mimeTypeDescription = (MimeTypeDescription)arrayList.get(i);
            if (mimeTypeDescription.getMimeType().equals(string)) {
                return mimeTypeDescription.getExtensions();
            }
            List list = this.getExtensionsFor(string, mimeTypeDescription.getRequiringTypes());
            if (list == null) continue;
            return list;
        }
        return null;
    }

    private boolean isReadableASCII(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (this.isReadableASCII(byArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isReadableASCII(int n) {
        return n == 9 || n == 10 || n == 13 || n >= 32 && n <= 126;
    }
}

