/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustdecider.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.semanticdesktop.aperture.security.trustdecider.Decision;
import org.semanticdesktop.aperture.security.trustdecider.TrustDecider;
import org.semanticdesktop.aperture.security.trustdecider.dialog.CertificateDialog;
import org.semanticdesktop.aperture.util.ResourceUtil;

public class TrustDeciderDialog
implements TrustDecider {
    private static final String RESOURCE_PACKAGE = "org/semanticdesktop/aperture/security/trustdecider/dialog/";
    private static final String WARNING_ICON_RESOURCE = "org/semanticdesktop/aperture/security/trustdecider/dialog/warning.png";
    private static final String CHECK_ICON_RESOURCE = "org/semanticdesktop/aperture/security/trustdecider/dialog/check.png";
    private Component parent;

    public void setParent(Component component) {
        this.parent = component;
    }

    public Component getParent() {
        return this.parent;
    }

    public Decision decide(final X509Certificate[] x509CertificateArray, boolean bl, boolean bl2) {
        int n = -1;
        int n2 = x509CertificateArray.length - 1;
        if (x509CertificateArray[0] instanceof X509Certificate && x509CertificateArray[n2] instanceof X509Certificate) {
            Object[] objectArray;
            X509Certificate x509Certificate = x509CertificateArray[0];
            X509Certificate x509Certificate2 = x509CertificateArray[n2];
            Principal principal = x509Certificate.getSubjectDN();
            Principal principal2 = x509Certificate2.getIssuerDN();
            String string = principal.getName();
            String string2 = null;
            int n3 = string.indexOf("CN=");
            int n4 = 0;
            if (n3 < 0) {
                string2 = "Unknown subject";
            } else {
                try {
                    n4 = string.charAt(n3 += 3) == '\"' ? string.indexOf(34, ++n3) : string.indexOf(44, n3);
                    string2 = n4 < 0 ? string.substring(n3) : string.substring(n3, n4);
                }
                catch (Throwable throwable) {
                    string2 = "Unknown subject";
                }
            }
            String string3 = principal2.getName();
            String string4 = null;
            n3 = string3.indexOf("O=");
            n4 = 0;
            if (n3 < 0) {
                string4 = "Unknown issuer";
            } else {
                try {
                    n4 = string3.charAt(n3 += 2) == '\"' ? string3.indexOf(34, ++n3) : string3.indexOf(44, n3);
                    string4 = n4 < 0 ? string3.substring(n3) : string3.substring(n3, n4);
                }
                catch (Throwable throwable) {
                    string4 = "Unknown issuer";
                }
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("Do you want to accept the certificate from " + string2);
            arrayList.add("for the purpose of exchanging encrypted information?");
            arrayList.add(" ");
            arrayList.add("Publisher authenticity verified by: " + string4);
            arrayList.add(" ");
            if (bl) {
                objectArray = new JLabel("The security certificate was issued by a company that is not trusted.");
                objectArray.setIcon(this.getImageIcon(WARNING_ICON_RESOURCE));
                arrayList.add(objectArray);
            } else {
                objectArray = new JLabel("The security certificate was issued by a company that is trusted.");
                objectArray.setIcon(this.getImageIcon(CHECK_ICON_RESOURCE));
                arrayList.add(objectArray);
            }
            if (bl2) {
                objectArray = new JLabel("The security certificate has expired or is not yet valid.");
                objectArray.setIcon(this.getImageIcon(WARNING_ICON_RESOURCE));
                arrayList.add(objectArray);
            } else {
                objectArray = new JLabel("The security certificate has not expired and is still valid.");
                objectArray.setIcon(this.getImageIcon(CHECK_ICON_RESOURCE));
                arrayList.add(objectArray);
            }
            arrayList.add(" ");
            arrayList.add("<html><b>Caution:</b> " + string2 + " asserts that this content is safe.");
            arrayList.add("You should only accept this content if you trust " + string2 + " to make that assertion.");
            objectArray = new JButton[]{new JButton("Accept for Session"), new JButton("Always Accept"), new JButton("Deny"), new JButton("View Certificate(s)")};
            final JButton jButton = objectArray[3];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Component component = (Component)actionEvent.getSource();
                        JButton jButton2 = (JButton)component;
                        if (jButton2 == jButton) {
                            CertificateDialog certificateDialog = new CertificateDialog(x509CertificateArray);
                            certificateDialog.show(TrustDeciderDialog.this.parent);
                        } else {
                            while (component != null) {
                                if (!((component = component.getParent()) instanceof JOptionPane)) continue;
                                ((JOptionPane)component).setValue(jButton2);
                                break;
                            }
                        }
                    }
                });
            }
            n = JOptionPane.showOptionDialog(this.parent, arrayList.toArray(), "Security Alert", -1, 2, null, objectArray, objectArray[2]);
        }
        if (n == 0) {
            return Decision.TRUST_THIS_SESSION;
        }
        if (n == 1) {
            return Decision.TRUST_ALWAYS;
        }
        if (n == 2) {
            return Decision.DISTRUST;
        }
        return null;
    }

    private ImageIcon getImageIcon(String string) {
        ImageIcon imageIcon = null;
        URL uRL = ResourceUtil.getURL(string, TrustDeciderDialog.class);
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }
}

