/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.subcrawler.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerFactory;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerRegistry;

public class SubCrawlerRegistryImpl
implements SubCrawlerRegistry {
    private HashMap subCrawlerFactories = new HashMap();

    public void add(SubCrawlerFactory subCrawlerFactory) {
        if (subCrawlerFactory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String string : subCrawlerFactory.getSupportedMimeTypes()) {
            HashSet<SubCrawlerFactory> hashSet = (HashSet<SubCrawlerFactory>)this.subCrawlerFactories.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<SubCrawlerFactory>();
                this.subCrawlerFactories.put(string, hashSet);
            }
            hashSet.add(subCrawlerFactory);
        }
    }

    public void remove(SubCrawlerFactory subCrawlerFactory) {
        for (String string : subCrawlerFactory.getSupportedMimeTypes()) {
            Set set = (Set)this.subCrawlerFactories.get(string);
            if (set == null) continue;
            set.remove(subCrawlerFactory);
            if (!set.isEmpty()) continue;
            this.subCrawlerFactories.remove(string);
        }
    }

    public Set get(String string) {
        Set set = (Set)this.subCrawlerFactories.get(string);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(set);
    }

    public Set getAll() {
        HashSet hashSet = new HashSet();
        for (Set set : this.subCrawlerFactories.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }
}

