/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.bibsonomy;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.QueryRow;
import org.ontoware.rdf2go.model.Syntax;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.vocabulary.TAGGING;
import org.semanticdesktop.aperture.websites.AbstractTagCrawler;
import org.semanticdesktop.aperture.websites.Tag;
import org.semanticdesktop.aperture.websites.bibsonomy.BibsonomyDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BibsonomyCrawler
extends AbstractTagCrawler {
    private static final String BIBSONOMY_URL = "http://www.bibsonomy.org/rss/user/";
    private static final String TAG_URL = "http://www.bibsonomy.org/user/";
    private static final String TAXO_NS = "http://purl.org/rss/1.0/modules/taxonomy/";
    private Logger log = LoggerFactory.getLogger(BibsonomyCrawler.class);
    private Map<Tag, List<String>> links;

    public BibsonomyCrawler(DataSource dataSource) {
        BibsonomyDataSource bibsonomyDataSource = (BibsonomyDataSource)dataSource;
        this.setDataSource(bibsonomyDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> crawlTags(String string, String string2) throws Exception {
        Object object;
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Username may not be empty");
        }
        URL uRL = new URL(BIBSONOMY_URL + string + "?items=10000");
        Model model = RDF2Go.getModelFactory().createModel();
        model.open();
        model.readFrom(uRL.openStream(), Syntax.RdfXml);
        String string3 = "PREFIX rss: <http://purl.org/rss/1.0/> \nPREFIX taxo: <http://purl.org/rss/1.0/modules/taxonomy/> \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?i ?l ?t \nWHERE { ?i rss:title ?l . \n        ?i taxo:topics ?blank . \n        ?blank ?predicate ?t . \n        FILTER ( ?predicate != rdf:type ) } \n";
        QueryResultTable queryResultTable = null;
        ClosableIterator closableIterator = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            queryResultTable = model.sparqlSelect(string3);
            closableIterator = queryResultTable.iterator();
            this.links = new HashMap<Tag, List<String>>();
            while (closableIterator.hasNext()) {
                object = (QueryRow)closableIterator.next();
                Tag tag = new Tag(object.getValue("i").toString(), object.getValue("l").toString(), TAGGING.Link.toString());
                List<String> list = this.links.get(tag);
                if (list == null) {
                    list = new Vector<String>();
                    this.links.put(tag, list);
                }
                String string4 = object.getValue("t").toString();
                list.add(string4);
                hashSet.add(string4);
            }
            this.closeIterator((ClosableIterator<? extends Object>)closableIterator);
        }
        catch (Throwable throwable) {
            this.closeIterator(closableIterator);
            throw throwable;
        }
        object = new Vector(hashSet);
        return object;
    }

    private void closeIterator(ClosableIterator<? extends Object> closableIterator) {
        if (closableIterator != null) {
            try {
                closableIterator.close();
            }
            catch (Exception exception) {
                this.log.warn("Coudln't close an iterator", (Throwable)exception);
            }
        }
    }

    @Override
    protected void crawlTheRest(String string, String string2) throws Exception {
        BibsonomyDataSource.CrawlType crawlType = ((BibsonomyDataSource)this.source).getCrawlType();
        if (crawlType != null && (crawlType.equals((Object)BibsonomyDataSource.CrawlType.ItemsAndTagsCrawlType) || crawlType.equals((Object)BibsonomyDataSource.CrawlType.ItemsAndTagsCrawlType))) {
            for (Map.Entry<Tag, List<String>> entry : this.links.entrySet()) {
                this.reportItem(entry.getKey(), entry.getValue());
            }
        }
    }

    public void postTag(String string, String string2, String string3, List<Tag> list) {
        String string4 = "http://www.bibsonomy.org/bookmark_posting_process";
    }
}

