/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.rhq.plugin;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.modeshape.rhq.plugin.EngineComponent;
import org.modeshape.rhq.plugin.util.ModeShapeManagementView;
import org.modeshape.rhq.plugin.util.ProfileServiceUtil;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;

public class RepositoryDiscoveryComponent
implements ResourceDiscoveryComponent<EngineComponent> {
    private final Log log = LogFactory.getLog((String)"org.modeshape");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ManagedComponent mc = ProfileServiceUtil.getManagedComponent(((EngineComponent)discoveryContext.getParentResourceComponent()).getConnection(), new ComponentType("ModeShape", "Engine"), "ModeShapeEngine");
        if (mc == null) {
            this.log.debug((Object)"No ModeShape Repositories discovered");
            return discoveredResources;
        }
        String operation = "getRepositories";
        MetaValue repositories = ModeShapeManagementView.executeManagedOperation(mc, operation, new MetaValue[]{null});
        if (repositories == null) {
            return discoveredResources;
        }
        Collection<MetaValue> repositoryCollection = ModeShapeManagementView.getRepositoryCollectionValue(repositories);
        for (MetaValue managedRepository : repositoryCollection) {
            MetaValue name = ((CompositeValueSupport)managedRepository).get("name");
            MetaValue version = ModeShapeManagementView.executeManagedOperation(mc, "getRepositoryVersion", name);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), ProfileServiceUtil.stringValue(name), ProfileServiceUtil.stringValue(name), ProfileServiceUtil.stringValue(version), "An information store with hierarchical organization, versioning, events, search, query, and automated content extraction", discoveryContext.getDefaultPluginConfiguration(), null);
            Configuration c = detail.getPluginConfiguration();
            operation = "getRepositoryProperties";
            MetaValue[] args = new MetaValue[]{name};
            MetaValue properties = ModeShapeManagementView.executeManagedOperation(mc, operation, args);
            MetaValue[] propertyArray = ((CollectionValueSupport)properties).getElements();
            PropertyList list = new PropertyList("propertyList");
            PropertyMap propMap = null;
            c.put((Property)list);
            for (MetaValue property : propertyArray) {
                CompositeValueSupport proCvs = (CompositeValueSupport)property;
                propMap = new PropertyMap("map");
                propMap.put((Property)new PropertySimple("label", (Object)ProfileServiceUtil.stringValue(proCvs.get("label"))));
                propMap.put((Property)new PropertySimple("value", (Object)ProfileServiceUtil.stringValue(proCvs.get("value"))));
                list.add((Property)propMap);
            }
            discoveredResources.add(detail);
            this.log.debug((Object)("Discovered ModeShape Repository: " + name));
        }
        return discoveredResources;
    }
}

