/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.addressbook;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AddressbookCrawler
extends CrawlerBase {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String ADDRESSBOOK_CHECKSUM_KEY = "ADDRESSBOOK_CHECKSUM";

    protected ExitCode crawlObjects() {
        boolean bl = false;
        try {
            List list = this.crawlAddressbook();
            URI uRI = this.getContactListUri();
            if (!this.accessData.isKnownId(uRI.toString())) {
                this.reportContactListDataObject(uRI);
            }
            for (DataObject dataObject : list) {
                String string = this.computeChecksum(dataObject);
                if (this.accessData.isKnownId(dataObject.getID().toString())) {
                    if (this.accessData.get(dataObject.getID().toString(), ADDRESSBOOK_CHECKSUM_KEY).equals(string)) {
                        this.reportUnmodifiedDataObject(dataObject.getID().toString());
                        continue;
                    }
                    this.reportModifiedDataObject(dataObject);
                    continue;
                }
                this.accessData.put(dataObject.getID().toString(), ADDRESSBOOK_CHECKSUM_KEY, string);
                this.reportNewDataObject(dataObject);
            }
            bl = true;
        }
        catch (Exception exception) {
            this.logger.error("Could not crawl addressbook data source", (Throwable)exception);
            return ExitCode.FATAL_ERROR;
        }
        return bl ? ExitCode.COMPLETED : ExitCode.STOP_REQUESTED;
    }

    private void reportContactListDataObject(URI uRI) {
        RDFContainerFactory rDFContainerFactory = this.getRDFContainerFactory(uRI.toString());
        RDFContainer rDFContainer = rDFContainerFactory.getRDFContainer(uRI);
        rDFContainer.add(RDF.type, (Node)NCO.ContactList);
        rDFContainer.add(NIE.rootElementOf, (Node)this.getDataSource().getID());
        DataObjectBase dataObjectBase = new DataObjectBase(uRI, this.source, rDFContainer);
        this.reportNewDataObject(dataObjectBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeChecksum(DataObject dataObject) {
        Object object;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.logger.warn("MD5 not available - using no checksum.");
            return "nochecksum";
        }
        RDFContainer rDFContainer = dataObject.getMetadata();
        Model model = rDFContainer.getModel();
        Vector<String> vector = new Vector<String>();
        ClosableIterator closableIterator = null;
        try {
            closableIterator = model.findStatements((ResourceOrVariable)rDFContainer.getDescribedUri(), (UriOrVariable)Variable.ANY, (NodeOrVariable)Variable.ANY);
            while (closableIterator.hasNext()) {
                object = (Statement)closableIterator.next();
                if (object.getObject() instanceof BlankNode) {
                    this.logger.warn("BlankNodes messes up checksum generation!");
                }
                vector.add(object.getPredicate().toString() + object.getObject().toString());
            }
        }
        catch (ModelRuntimeException modelRuntimeException) {
            this.logger.error("Could not find statements", (Throwable)modelRuntimeException);
        }
        finally {
            if (closableIterator != null) {
                closableIterator.close();
            }
        }
        Collections.sort(vector);
        object = vector.iterator();
        while (object.hasNext()) {
            messageDigest.update(((String)object.next()).getBytes());
        }
        object = new StringBuilder("");
        byte[] byArray = messageDigest.digest();
        for (int i = 0; i < byArray.length; ++i) {
            ((StringBuilder)object).append(Integer.toHexString(byArray[i]));
        }
        return ((StringBuilder)object).toString();
    }

    public abstract List crawlAddressbook() throws Exception;

    public abstract URI getContactListUri();
}

