/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.imap;

import com.sun.mail.imap.IMAPFolder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.FolderDataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.imap.ImapStreamPool;
import org.semanticdesktop.aperture.crawler.mail.AbstractJavaMailCrawler;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.imap.ImapDataSource;
import org.semanticdesktop.aperture.security.trustmanager.standard.StandardTrustManager;
import org.semanticdesktop.aperture.util.HttpClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapCrawler
extends AbstractJavaMailCrawler
implements DataAccessor {
    private static final String IMAP_URL_SCHEME = "imap://";
    private static final String NEXT_UID_KEY = "nextuid";
    private static final String SIZE_KEY = "size";
    private static final String SUBFOLDERS_KEY = "subfolders";
    private static final String UID_VALIDITY = "uidValidity";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ImapDataSource configuredDataSource;
    private Properties sessionProperties;
    private String hostName;
    private int port;
    private String userName;
    private String password;
    private String connectionType;
    private boolean ignoreSSLCertificates = false;
    private boolean useSSLCertificateFile = false;
    private String SSLCertificateFile;
    private String SSLCertificatePassword;
    private boolean includeInbox;
    private Store store;
    private ImapStreamPool streamPool;
    private Message[] currentMessages;
    private boolean currentFolderChanged;

    @Override
    protected ExitCode crawlObjects() {
        this.retrieveConfigurationData(this.getDataSource());
        try {
            this.ensureConnectedStore();
        }
        catch (MessagingException messagingException) {
            this.logger.warn("Unable to connect to IMAP mail store", (Throwable)messagingException);
            this.closeConnection();
            return ExitCode.FATAL_ERROR;
        }
        boolean bl = false;
        try {
            int n = this.baseFolders.size();
            if (n == 0) {
                this.crawlFolder(this.store.getDefaultFolder(), 0);
            } else {
                for (int i = 0; i < n; ++i) {
                    String string = (String)this.baseFolders.get(i);
                    Folder folder = this.store.getFolder(string);
                    this.crawlFolder(folder, 0);
                }
            }
            if (this.includeInbox) {
                this.crawlFolder(this.store.getFolder("INBOX"), 0);
            }
        }
        catch (MessagingException messagingException) {
            this.logger.warn("MessagingException while crawling", (Throwable)messagingException);
            bl = true;
        }
        this.closeConnection();
        if (bl) {
            return ExitCode.FATAL_ERROR;
        }
        if (this.isStopRequested()) {
            return ExitCode.STOP_REQUESTED;
        }
        return ExitCode.COMPLETED;
    }

    private void retrieveConfigurationData(DataSource dataSource) {
        Long l;
        if (dataSource == this.configuredDataSource) {
            return;
        }
        this.configuredDataSource = (ImapDataSource)dataSource;
        this.hostName = this.configuredDataSource.getHostname();
        this.userName = this.configuredDataSource.getUsername();
        this.password = this.configuredDataSource.getPassword();
        this.port = -1;
        Integer n = this.configuredDataSource.getPort();
        if (n != null) {
            this.port = n;
        }
        this.baseFolders.clear();
        this.baseFolders.addAll(this.configuredDataSource.getAllBasepaths());
        Boolean bl = this.configuredDataSource.getIncludeInbox();
        this.includeInbox = bl == null ? false : bl;
        Integer n2 = this.configuredDataSource.getMaximumDepth();
        this.maxDepth = n2 == null ? -1 : n2;
        ImapDataSource.ConnectionSecurity connectionSecurity = this.configuredDataSource.getConnectionSecurity();
        if (connectionSecurity == null || connectionSecurity.equals((Object)ImapDataSource.ConnectionSecurity.PLAIN)) {
            this.connectionType = "imap";
        } else if (connectionSecurity.equals((Object)ImapDataSource.ConnectionSecurity.SSL) || connectionSecurity.equals((Object)ImapDataSource.ConnectionSecurity.SSL_NO_CERT)) {
            this.connectionType = "imaps";
        } else {
            throw new IllegalArgumentException("Illegal connection security type: " + (Object)((Object)connectionSecurity));
        }
        if (connectionSecurity != null && connectionSecurity.equals((Object)ImapDataSource.ConnectionSecurity.SSL_NO_CERT)) {
            this.ignoreSSLCertificates = true;
        }
        if (this.configuredDataSource.getSslFileName() != null) {
            this.useSSLCertificateFile = true;
            this.SSLCertificateFile = this.configuredDataSource.getSslFileName();
            this.SSLCertificatePassword = this.configuredDataSource.getSslFilePassword();
        }
        this.maximumByteSize = (l = this.configuredDataSource.getMaximumSize()) == null ? Long.MAX_VALUE : l;
        if (this.store != null) {
            this.closeConnection();
            this.store = null;
        }
    }

    private void ensureConnectedStore() throws MessagingException {
        if (this.store == null) {
            Object object;
            Properties properties = System.getProperties();
            if (this.ignoreSSLCertificates) {
                properties.setProperty("mail.imaps.socketFactory.class", SimpleSocketFactory.class.getName());
                properties.setProperty("mail.imaps.socketFactory.fallback", "false");
            }
            if (this.useSSLCertificateFile) {
                properties.setProperty("javax.net.ssl.trustStore", this.SSLCertificateFile);
                properties.setProperty("javax.net.ssl.trustStorePassword", this.SSLCertificatePassword);
            }
            if (this.sessionProperties != null) {
                object = this.sessionProperties.elements();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    String string2 = this.sessionProperties.getProperty(string);
                    properties.setProperty(string, string2);
                }
            }
            object = Session.getDefaultInstance((Properties)properties);
            this.store = object.getStore(this.connectionType);
        }
        if (!this.store.isConnected()) {
            this.store.connect(this.hostName, this.port, this.userName, this.password);
        }
        this.streamPool = new ImapStreamPool(this.store);
    }

    public void closeConnection() {
        if (this.streamPool != null) {
            this.streamPool.requestClose();
        }
    }

    @Override
    public DataObject getDataObject(String string, DataSource dataSource, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        return this.getDataObjectIfModified(string, dataSource, null, map, rDFContainerFactory);
    }

    @Override
    public DataObject getDataObjectIfModified(String string, DataSource dataSource, AccessData accessData, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        IOException iOException;
        this.retrieveConfigurationData(dataSource);
        try {
            this.ensureConnectedStore();
            String string2 = ImapCrawler.getFolderName(string);
            iOException = string2 == null || string2.equals("") ? this.store.getDefaultFolder() : this.store.getFolder(string2);
            if (!iOException.exists()) {
                throw new UrlNotFoundException(string, "unknown folder");
            }
            if (!iOException.isOpen() && ImapCrawler.holdsMessages((Folder)iOException)) {
                iOException.open(1);
            }
            super.setCurrentFolder((Folder)iOException);
            int n = string.indexOf(";TYPE=");
            if (n < 0) {
                long l;
                int n2 = string.lastIndexOf("/;UID=");
                if ((n2 = Math.max(n2, string.lastIndexOf("/;uid="))) < 0 || n2 >= string.length() - 6) {
                    throw new IllegalArgumentException("unable to get message UID from " + string);
                }
                String string3 = string.substring(n2 + 6);
                n2 = string3.indexOf(35);
                if ((n2 = Math.max(n2, string3.indexOf(47))) > 0 && n2 < string3.length() - 1) {
                    string3 = string3.substring(0, n2);
                }
                try {
                    l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("illegal message UID: " + string3);
                }
                MimeMessage mimeMessage = (MimeMessage)((UIDFolder)iOException).getMessageByUID(l);
                if (mimeMessage == null) {
                    throw new UrlNotFoundException("unknown UID: " + l);
                }
                DataObject dataObject = this.getObject(mimeMessage, string, this.getFolderURI((Folder)iOException), dataSource, accessData, rDFContainerFactory);
                return dataObject;
            }
            FolderDataObject folderDataObject = this.getCurrentFolderObject(dataSource, accessData, rDFContainerFactory);
            return folderDataObject;
        }
        catch (MessagingException messagingException) {
            iOException = new IOException();
            iOException.initCause(messagingException);
            throw iOException;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    protected void setCurrentFolder(Folder folder) throws MessagingException {
        boolean bl;
        super.setCurrentFolder(folder);
        if (!ImapCrawler.holdsMessages(folder)) {
            this.currentFolderChanged = this.checkSubfoldersChanged();
            this.currentMessages = null;
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Prefetching started: " + this.currentFolderURI);
        }
        this.currentMessages = folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DELETED), false));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Folder has " + this.currentMessages.length + " non-deleted msgs");
        }
        this.currentMessages = this.getNonExpungedMessages(this.currentMessages);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Folder contains " + this.currentMessages.length + " non-expunged msgs");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Prefetching uids");
        }
        FetchProfile fetchProfile = new FetchProfile();
        fetchProfile.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        fetchProfile.add(FetchProfile.Item.FLAGS);
        fetchProfile.add(FetchProfile.Item.ENVELOPE);
        folder.fetch(this.currentMessages, fetchProfile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Prefetching uids completed");
        }
        boolean bl2 = false;
        int n = this.getCurrentFolderMessageCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        boolean bl3 = bl = this.accessData != null ? this.checkCurrentFolderUIDValidity(this.accessData) : false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("UID validity " + bl);
        }
        String string = this.currentFolderURI.toString();
        if (this.accessData != null && bl) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Narrowing the current messages array");
            }
            bl2 = this.narrowCurrentMessagesArray(this.accessData, arrayList, string);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Narrowing completed, " + this.currentMessages.length + " msgs left, folderChanged: " + bl2);
            }
        } else if (this.accessData != null && !bl) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing folder info from access data");
            }
            bl2 = this.removeFolderInfoFromAccessData(string);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No access data detected");
            }
            bl2 = true;
        }
        if (this.isStopRequested()) {
            return;
        }
        this.currentFolderChanged = bl2 ? true : this.checkSubfoldersChanged();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finally, after checking subfolders, folderChanged: " + this.currentFolderChanged);
        }
        if (this.currentFolderChanged) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Prefetching content info of " + this.currentMessages.length + " msgs");
            }
            fetchProfile = new FetchProfile();
            fetchProfile.add(FetchProfile.Item.CONTENT_INFO);
            this.currentFolder.fetch(this.currentMessages, fetchProfile);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Prefetching content info completed");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Reporting " + arrayList.size() + " unmodified msgs");
            }
            for (String string2 : arrayList) {
                this.reportNotModified(string2);
            }
        }
    }

    private Message[] getNonExpungedMessages(Message[] messageArray) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (Message message : messageArray) {
            if (message.isExpunged()) continue;
            arrayList.add(message);
        }
        return arrayList.toArray(new Message[arrayList.size()]);
    }

    @Override
    protected int getCurrentFolderMessageCount() throws MessagingException {
        return this.currentMessages.length;
    }

    @Override
    protected Message getMessageFromCurrentFolder(int n) throws MessagingException {
        return this.currentMessages[n - 1];
    }

    @Override
    public InputStream getPartStream(Part part) throws MessagingException, IOException {
        return this.streamPool.getStreamForAMessage(part);
    }

    private boolean narrowCurrentMessagesArray(AccessData accessData, ArrayList<String> arrayList, String string) throws MessagingException {
        boolean bl = false;
        int n = this.getCurrentFolderMessageCount();
        ArrayList<MimeMessage> arrayList2 = new ArrayList<MimeMessage>(n);
        Set set = accessData.getReferredIDs(string);
        set = set == null ? Collections.EMPTY_SET : new HashSet(set);
        for (int i = 1; i <= n && !this.isStopRequested(); ++i) {
            Object object = (MimeMessage)this.getMessageFromCurrentFolder(i);
            String string2 = this.getMessageUri(this.currentFolder, (Message)object);
            if (set.contains(string2)) {
                set.remove(string2);
            } else {
                bl = true;
            }
            if (accessData.get(string2, "accessed") == null) {
                if (!this.isAcceptable((Message)object)) continue;
                arrayList2.add((MimeMessage)object);
                bl = true;
                continue;
            }
            if (this.isRemoved((Message)object)) {
                accessData.removeReferredID(string, string2);
                bl = true;
                continue;
            }
            arrayList.add(this.getMessageUri(this.currentFolder, (Message)object));
        }
        this.currentMessages = arrayList2.toArray(new Message[arrayList2.size()]);
        for (Object object : set) {
            accessData.removeReferredID(string, (String)object);
            bl = true;
        }
        return bl;
    }

    private boolean checkSubfoldersChanged() throws MessagingException {
        String string;
        String string2;
        boolean bl = true;
        if (this.accessData != null && ImapCrawler.holdsFolders(this.currentFolder) && (string2 = this.accessData.get(this.currentFolderURI.toString(), SUBFOLDERS_KEY)) != null && string2.equals(string = this.getSubFoldersString(this.currentFolder))) {
            bl = false;
        }
        return bl;
    }

    private boolean removeFolderInfoFromAccessData(String string) {
        if (this.accessData == null) {
            return false;
        }
        Set set = this.accessData.getReferredIDs(string);
        set = set == null ? Collections.EMPTY_SET : new HashSet(set);
        for (Object e : set) {
            this.accessData.remove(e.toString());
        }
        this.accessData.remove(string);
        boolean bl = true;
        return bl;
    }

    private boolean checkCurrentFolderUIDValidity(AccessData accessData) throws MessagingException {
        if (accessData == null) {
            return false;
        }
        String string = accessData.get(this.currentFolderURI.toString(), UID_VALIDITY);
        if (string == null) {
            return false;
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        long l2 = ((UIDFolder)this.currentFolder).getUIDValidity();
        return l == l2;
    }

    @Override
    protected void recordCurrentFolderInAccessData(AccessData accessData) throws MessagingException {
        IMAPFolder iMAPFolder = (IMAPFolder)this.currentFolder;
        String string = this.currentFolderURI.toString();
        if (accessData != null) {
            accessData.put(string, UID_VALIDITY, String.valueOf(iMAPFolder.getUIDValidity()));
            if (ImapCrawler.holdsFolders(this.currentFolder)) {
                accessData.put(string, SUBFOLDERS_KEY, this.getSubFoldersString(this.currentFolder));
            }
        }
    }

    @Override
    protected boolean checkIfCurrentFolderHasBeenChanged(AccessData accessData) throws MessagingException {
        return this.currentFolderChanged;
    }

    private String getFolderURIPrefix(Folder folder) throws MessagingException {
        StringBuilder stringBuilder = new StringBuilder(100);
        URLName uRLName = this.store.getURLName();
        stringBuilder.append(IMAP_URL_SCHEME);
        String string = uRLName.getUsername();
        if (string != null && !string.equals("")) {
            string = HttpClientUtil.formUrlEncode(string);
            stringBuilder.append(string);
            stringBuilder.append('@');
        }
        stringBuilder.append(uRLName.getHost());
        stringBuilder.append('/');
        stringBuilder.append(ImapCrawler.encodeFolderName(folder.getFullName()));
        return stringBuilder.toString();
    }

    public static String getFolderName(String string) {
        int n;
        if (!string.startsWith(IMAP_URL_SCHEME)) {
            return null;
        }
        int n2 = string.indexOf(47, 7);
        int n3 = n = string.endsWith(";TYPE=LIST") ? string.lastIndexOf(59) : string.lastIndexOf(47);
        if (n2 >= 0 && n > n2) {
            String string2 = string.substring(n2 + 1, n);
            try {
                return URLDecoder.decode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return null;
    }

    public static String encodeFolderName(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 10);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuilder.append('+');
                continue;
            }
            char c2 = c;
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '.') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('%');
            String string2 = Integer.toHexString(c);
            if (string2.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Override
    protected URI getFolderURI(Folder folder) throws MessagingException {
        return new URIImpl(this.getFolderURIPrefix(folder) + ";TYPE=LIST");
    }

    @Override
    protected String getMessageUri(Folder folder, Message message) throws MessagingException {
        return this.getFolderURIPrefix(folder) + "/;UID=" + ((UIDFolder)folder).getUID(message);
    }

    public void setSessionProperties(Properties properties) {
        this.sessionProperties = properties;
    }

    public Properties getSessionProperties() {
        return this.sessionProperties;
    }

    public static class SimpleSocketFactory
    extends SSLSocketFactory {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private SSLSocketFactory factory;

        public SimpleSocketFactory() {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, new TrustManager[]{new NaiveTrustManager()}, null);
                this.factory = sSLContext.getSocketFactory();
            }
            catch (Exception exception) {
                this.logger.error("Exception while setting up SimpleSocketFactory", (Throwable)exception);
            }
        }

        public SimpleSocketFactory(File file, String string) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                StandardTrustManager standardTrustManager = new StandardTrustManager(file, string.toCharArray());
                sSLContext.init(null, new TrustManager[]{standardTrustManager}, null);
                this.factory = sSLContext.getSocketFactory();
            }
            catch (Exception exception) {
                this.logger.error("Exception while setting up SimpleSocketFactory", (Throwable)exception);
            }
        }

        public static SocketFactory getDefault() {
            return new SimpleSocketFactory();
        }

        public Socket createSocket() throws IOException {
            return this.factory.createSocket();
        }

        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
            return this.factory.createSocket(socket, string, n, bl);
        }

        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            return this.factory.createSocket(inetAddress, n, inetAddress2, n2);
        }

        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            return this.factory.createSocket(inetAddress, n);
        }

        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
            return this.factory.createSocket(string, n, inetAddress, n2);
        }

        public Socket createSocket(String string, int n) throws IOException {
            return this.factory.createSocket(string, n);
        }

        public String[] getDefaultCipherSuites() {
            return this.factory.getDefaultCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        private class NaiveTrustManager
        implements X509TrustManager {
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }
    }
}

