/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.powerpoint;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.util.PoiUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerPointExtractor
implements Extractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        PoiUtil.extractAll(inputStream, new PowerPointTextExtractor(), rDFContainer, this.logger);
        rDFContainer.add(RDF.type, (Node)NFO.Presentation);
    }

    private static class PowerPointTextExtractor
    implements PoiUtil.TextExtractor {
        private PowerPointTextExtractor() {
        }

        public String getText(POIFSFileSystem pOIFSFileSystem) throws IOException {
            org.apache.poi.hslf.extractor.PowerPointExtractor powerPointExtractor = new org.apache.poi.hslf.extractor.PowerPointExtractor(pOIFSFileSystem);
            String string = powerPointExtractor.getText(true, true);
            if (string == null) {
                string = "";
            }
            return string;
        }
    }
}

