/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;

public class StringExtractor {
    private static final String END_OF_LINE = System.getProperty("line.separator", "\n");
    public static final String[] COMMON_FONT_NAMES = new String[]{"albertus medium", "albertus extra bold", "algerian", "antique olive", "arial", "book antiqua", "bookman old style", "braggadocio", "britannic bold", "brush script mt", "century gothic", "century schoolbook", "cg omega", "cg times", "clarendon condensed", "colonna mt", "coronet", "courier", "courier new", "desdemona", "footlight mt light", "garamond", "helvetica", "impact", "kino mt", "line printer", "marigold", "matura mt script capitals", "modern", "monotype corsiva", "letter gothic", "playbill", "roman", "script", "symbol", "tahoma", "times new roman", "times roman", "univers", "univers condensed", "verdana", "wide latin", "wingdings"};

    public String extract(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(512);
        StringBuilder stringBuilder2 = new StringBuilder(65536);
        int n = -1;
        while ((n = inputStream.read()) != -1) {
            if (this.isTextCharacter(n)) {
                stringBuilder.append((char)n);
                continue;
            }
            if (stringBuilder.length() <= 0) continue;
            String string = stringBuilder.toString();
            stringBuilder.setLength(0);
            if ((string = this.postProcessLine(string)) == null) continue;
            String string2 = string.toLowerCase();
            if (this.isStartLine(string2)) {
                stringBuilder2.setLength(0);
                continue;
            }
            if (!this.isValidLine(string2)) continue;
            stringBuilder2.append(string);
            stringBuilder2.append(END_OF_LINE);
        }
        return stringBuilder2.toString();
    }

    protected boolean isStartLine(String string) {
        return false;
    }

    protected boolean isValidLine(String string) {
        for (int i = 0; i < COMMON_FONT_NAMES.length; ++i) {
            if (!string.startsWith(COMMON_FONT_NAMES[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isTextCharacter(int n) {
        return n >= 32 && n <= 126 || n == 9;
    }

    protected String postProcessLine(String string) {
        if ((string = string.trim()).length() <= 2) {
            string = null;
        } else {
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens() && !bl) {
                bl = this.isNormalWord(stringTokenizer.nextToken());
            }
            if (!bl) {
                string = null;
            }
        }
        return string;
    }

    protected boolean isNormalWord(String string) {
        int n;
        boolean bl = false;
        int n2 = string.length();
        if (n2 > 0 && ((n = string.charAt(n2 - 1)) == 46 || n == 44)) {
            --n2;
        }
        if (n2 >= 3) {
            bl = true;
            for (n = 0; n < n2 && bl; ++n) {
                if (Character.isLetter(string.charAt(n))) continue;
                bl = false;
            }
            if (Character.isUpperCase(string.charAt(0))) {
                if (Character.isUpperCase(string.charAt(1))) {
                    for (n = 2; n < n2 && bl; ++n) {
                        bl = Character.isUpperCase(string.charAt(n));
                    }
                } else {
                    for (n = 2; n < n2 && bl; ++n) {
                        bl = !Character.isUpperCase(string.charAt(n));
                    }
                }
            } else {
                for (n = 0; n < n2 && bl; ++n) {
                    bl = !Character.isUpperCase(string.charAt(n));
                }
            }
            if (bl) {
                Integer n3;
                Object object;
                int n4;
                HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(32);
                for (n4 = 0; n4 < n2; ++n4) {
                    object = new Character(string.charAt(n4));
                    n3 = (Integer)hashMap.get(object);
                    n3 = n3 == null ? new Integer(1) : new Integer(n3 + 1);
                    hashMap.put(object, n3);
                }
                n4 = n2 / 2;
                object = hashMap.values().iterator();
                while (object.hasNext() && bl) {
                    n3 = (Integer)object.next();
                    bl = n3 < n4;
                }
            }
        }
        return bl;
    }
}

