/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.opener.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.opener.DataOpenerFactory;
import org.semanticdesktop.aperture.opener.DataOpenerRegistry;

public class DataOpenerRegistryImpl
implements DataOpenerRegistry {
    private HashMap factories = new HashMap();

    public void add(DataOpenerFactory dataOpenerFactory) {
        if (dataOpenerFactory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String string : dataOpenerFactory.getSupportedSchemes()) {
            HashSet<DataOpenerFactory> hashSet = (HashSet<DataOpenerFactory>)this.factories.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<DataOpenerFactory>();
                this.factories.put(string, hashSet);
            }
            hashSet.add(dataOpenerFactory);
        }
    }

    public void remove(DataOpenerFactory dataOpenerFactory) {
        for (String string : dataOpenerFactory.getSupportedSchemes()) {
            Set set = (Set)this.factories.get(string);
            if (set == null) continue;
            set.remove(dataOpenerFactory);
            if (!set.isEmpty()) continue;
            this.factories.remove(string);
        }
    }

    public Set get(String string) {
        Set set = (Set)this.factories.get(string);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(set);
    }

    public Set getAll() {
        HashSet hashSet = new HashSet();
        for (Set set : this.factories.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }
}

