/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustmanager.standard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.semanticdesktop.aperture.security.trustmanager.standard.CertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootCertificateStore
implements CertificateStore {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String fileName;
    private KeyStore keyStore;

    public RootCertificateStore(String string) {
        this.fileName = string;
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
                    File file;
                    if (RootCertificateStore.this.keyStore == null) {
                        RootCertificateStore.this.keyStore = KeyStore.getInstance("JKS");
                        RootCertificateStore.this.keyStore.load(null, null);
                    }
                    if ((file = new File(RootCertificateStore.this.fileName)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        RootCertificateStore.this.keyStore.load(bufferedInputStream, null);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            this.logger.error("Unrecognized nested exception, ignoring", (Throwable)privilegedActionException);
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
    }

    public void add(Certificate certificate) throws KeyStoreException {
    }

    public void remove(Certificate certificate) throws KeyStoreException {
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return false;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this.keyStore.getCertificate(string);
            try {
                certificate.verify(certificate2.getPublicKey());
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            hashSet.add(this.keyStore.getCertificate(string));
        }
        return hashSet.iterator();
    }
}

