/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.QueryRow;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;
import org.semanticdesktop.aperture.vocabulary.FRESNEL;
import org.semanticdesktop.aperture.vocabulary.SOURCEFORMAT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceClassGenerator {
    private static Logger log = LoggerFactory.getLogger(DataSourceClassGenerator.class);
    public static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
    public static final Set<String> JAVA_RESERVED_WORDS_SET = DataSourceClassGenerator.prepareJavaKeywordSet();
    String inputRdfFilePath = null;
    String outputDirectoryPath = null;
    String outputFileName = null;
    String classUri = null;
    String packageName = null;
    String vocabularyClassName = null;
    Model myModel = null;
    PrintStream outputStream;
    private File inputRdfFile;
    private File outputDirFile;
    private File outputFile;
    private Boolean namespacestrict = false;
    private Syntax inputFileSyntax;
    private boolean domainBoundableDataSource = false;
    HashMap<String, String> uriToLocalName = new HashMap();
    private boolean forceGeneration = false;

    private static Set<String> prepareJavaKeywordSet() {
        HashSet<String> hashSet = new HashSet<String>(100);
        for (String string : JAVA_RESERVED_WORDS) {
            hashSet.add(string);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public void go(String[] stringArray) throws Exception {
        this.getOpt(stringArray);
        if (this.ontologyUpToDate()) {
            return;
        }
        this.loadOnt();
        this.writeDataSourceClass();
    }

    private boolean ontologyUpToDate() {
        if (this.outputFile.canRead() && !this.forceGeneration) {
            long l = this.inputRdfFile.lastModified();
            long l2 = this.outputFile.lastModified();
            return l2 >= l;
        }
        return false;
    }

    private void loadOnt() throws Exception {
        this.myModel = RDF2Go.getModelFactory().createModel();
        this.myModel.open();
        this.inputFileSyntax = this.getSyntax(this.inputRdfFilePath);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.inputRdfFile));
        this.myModel.readFrom((Reader)bufferedReader, this.inputFileSyntax);
        DATASOURCE.getDATASOURCEOntology(this.myModel);
        SOURCEFORMAT.getSOURCEFORMATOntology(this.myModel);
        ((Reader)bufferedReader).close();
    }

    private Syntax getSyntax(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return Syntax.RdfXml;
        }
        String string2 = string.substring(n + 1);
        if ("rdf".equals(string2) || "rdfs".equals(string2)) {
            return Syntax.RdfXml;
        }
        if ("ttl".equals(string2) || "nt".equals(string2) || "n3".equals(string2)) {
            return Syntax.Turtle;
        }
        if ("trix".equals(string2)) {
            return Syntax.Trix;
        }
        if ("trig".equals(string2)) {
            return Syntax.Trig;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataSourceClass() throws Exception {
        this.outputStream = new PrintStream(this.outputFile);
        try {
            URI uRI = this.getFresnelLensURI(this.myModel, this.classUri);
            List<URI> list = this.getConfigurationOptionsList(uRI);
            this.outputStream.println("package " + this.packageName + ";");
            this.outputStream.println("import " + URI.class.getName() + ";");
            this.outputStream.println("import " + Node.class.getName() + ";");
            this.outputStream.println("import " + ModelUtil.class.getName() + ";");
            this.outputStream.println("import org.semanticdesktop.aperture.datasource.DataSource;");
            this.outputStream.println("import org.semanticdesktop.aperture.datasource.base.DataSourceBase;");
            this.outputStream.println("import org.semanticdesktop.aperture.datasource.config.ConfigurationUtil;");
            if (this.domainBoundableDataSource) {
                this.outputStream.println("import org.semanticdesktop.aperture.datasource.config.DomainBoundableDataSource;");
            }
            this.outputStream.println("import org.semanticdesktop.aperture.util.ModelUtil;");
            this.outputStream.println("import java.util.Collection;");
            this.outputStream.println("import java.util.List;");
            this.outputStream.println("import java.util.LinkedList;");
            this.outputStream.println();
            this.outputStream.println("/**");
            this.outputStream.println(" * Data source class file. Created by " + DataSourceClassGenerator.class.getName() + " on " + new Date());
            this.outputStream.println(" * input file: " + this.inputRdfFilePath);
            this.outputStream.println(" * class uri: " + this.classUri);
            this.outputStream.println(" */");
            this.outputStream.println("public class " + this.outputFileName + " extends " + (this.domainBoundableDataSource ? "DomainBoundableDataSource" : "DataSourceBase") + " {");
            this.outputStream.println();
            this.generateGetTypeMethod();
            for (URI uRI2 : list) {
                this.generateElement(uRI2);
            }
            this.outputStream.println("}");
        }
        finally {
            this.outputStream.close();
        }
    }

    private void generateGetTypeMethod() {
        this.outputStream.println("    /**");
        this.outputStream.println("     * @see DataSource#getType()");
        this.outputStream.println("     */");
        this.outputStream.println("    public URI getType() {");
        this.outputStream.println("        return " + this.vocabularyClassName + "." + this.outputFileName + ";");
        this.outputStream.println("    }");
    }

    private void generateElement(URI uRI) throws Exception {
        Node node = ModelUtil.getPropertyValue(this.myModel, (Resource)uRI, RDFS.comment);
        String string = node != null ? node.toString() : "";
        String string2 = this.asLegalJavaID(this.getLocalName(uRI.toString()), false);
        String string3 = this.asLegalJavaID(this.getLocalName(uRI.toString()), true);
        Node node2 = ModelUtil.getPropertyValue(this.myModel, (Resource)uRI, RDFS.range);
        URI uRI2 = node2 != null ? node2.asURI() : null;
        String string4 = this.getJavaRangeType(uRI2);
        String string5 = this.getVocabularyClassName(uRI);
        URI uRI3 = this.getWidgetType(uRI);
        if (string4.equals("DomainBoundaries")) {
            return;
        }
        if (uRI3.equals(SOURCEFORMAT.MultipleTextFieldWidget)) {
            this.generateMultiValuedProperty(string2, string3, string, string4, string5);
        } else if (uRI3.equals(SOURCEFORMAT.ComboBoxWidget)) {
            this.generateEnumProperty(string2, string3, string, string5, uRI);
        } else {
            this.generateSingleValuedProperty(string2, string3, string, string4, string5);
        }
        this.uriToLocalName.put(uRI.toString(), string2);
    }

    private void generateSingleValuedProperty(String string, String string2, String string3, String string4, String string5) {
        this.outputStream.println();
        this.outputStream.println("    /**");
        this.outputStream.println("     * Returns the " + string3);
        this.outputStream.println("     * ");
        this.outputStream.println("     * @return the " + string3 + " or null if no value has been set");
        this.outputStream.println("     * @throws NullPointerException if no configuration has been set, use");
        this.outputStream.println("     *             {@link #setConfiguration(RDFContainer)} before calling this method");
        this.outputStream.println("     */");
        this.outputStream.println("     public " + string4 + " get" + string2 + "() {");
        this.outputStream.println("          return getConfiguration().get" + string4 + "(" + string5 + "." + string + ");");
        this.outputStream.println("     }");
        this.outputStream.println();
        this.outputStream.println("    /**");
        this.outputStream.println("     * Sets the " + string3);
        this.outputStream.println("     * ");
        this.outputStream.println("     * @param " + string + " " + string3 + ", can be null in which case any previous setting will be removed");
        this.outputStream.println("     * @throws NullPointerException if no configuration has been set, use");
        this.outputStream.println("     *             {@link #setConfiguration(RDFContainer)} before calling this method");
        this.outputStream.println("     */");
        this.outputStream.println("     public void set" + string2 + "(" + string4 + " " + string + ") {");
        this.outputStream.println("         if ( " + string + " == null) {");
        this.outputStream.println("             getConfiguration().remove(" + string5 + "." + string + ");");
        this.outputStream.println("         } else {");
        this.outputStream.println("             getConfiguration().put(" + string5 + "." + string + "," + string + ");");
        this.outputStream.println("         }");
        this.outputStream.println("     }");
    }

    private void generateMultiValuedProperty(String string, String string2, String string3, String string4, String string5) {
        this.outputStream.println();
        this.outputStream.println("    /**");
        this.outputStream.println("     * Returns a collection of all values of " + string3);
        this.outputStream.println("     * ");
        this.outputStream.println("     * @return a collection of all values of " + string3 + " the collection may be empty if no values have been set");
        this.outputStream.println("     * @throws NullPointerException if no configuration has been set, use");
        this.outputStream.println("     *             {@link #setConfiguration(RDFContainer)} before calling this method");
        this.outputStream.println("     */");
        this.outputStream.println("     public Collection<" + string4 + "> getAll" + string2 + "s() {");
        this.outputStream.println("          Collection<Node> collection = (Collection<Node>)getConfiguration().getAll(" + string5 + "." + string + ");");
        this.outputStream.println("          List<" + string4 + "> result = new LinkedList<" + string4 + ">();");
        this.outputStream.println("          for (Node node : collection) {");
        this.outputStream.println("              " + string4 + " object = (" + string4 + ")ModelUtil.convertNode(node," + string4 + ".class);");
        this.outputStream.println("              if (object != null) {");
        this.outputStream.println("                   result.add(object);");
        this.outputStream.println("              }");
        this.outputStream.println("          }");
        this.outputStream.println("          return result;");
        this.outputStream.println("     }");
        this.outputStream.println();
        this.outputStream.println("    /**");
        this.outputStream.println("     * Sets the " + string3);
        this.outputStream.println("     * ");
        this.outputStream.println("     * @param " + string + " " + string3 + ", can be null in which case any previous setting will be removed");
        this.outputStream.println("     * @throws NullPointerException if no configuration has been set, use");
        this.outputStream.println("     *             {@link #setConfiguration(RDFContainer)} before calling this method");
        this.outputStream.println("     * @throws MultipleValuesException if this property had more that one value before this method was called");
        this.outputStream.println("     */");
        this.outputStream.println("     public void set" + string2 + "(" + string4 + " " + string + ") {");
        this.outputStream.println("         if ( " + string + " == null) {");
        this.outputStream.println("             getConfiguration().remove(" + string5 + "." + string + ");");
        this.outputStream.println("         } else {");
        this.outputStream.println("             getConfiguration().put(" + string5 + "." + string + "," + string + ");");
        this.outputStream.println("         }");
        this.outputStream.println("     }");
        this.outputStream.println();
        this.outputStream.println("    /**");
        this.outputStream.println("     * Sets all " + string3 + "s at once");
        this.outputStream.println("     * ");
        this.outputStream.println("     * @param " + string + " " + string3 + ", can be null in which case any previous setting will be removed");
        this.outputStream.println("     * @throws NullPointerException if no configuration has been set, use");
        this.outputStream.println("     *             {@link #setConfiguration(RDFContainer)} before calling this method");
        this.outputStream.println("     */");
        this.outputStream.println("     public void setAll" + string2 + "s(List<" + string4 + "> " + string + ") {");
        this.outputStream.println("         if ( " + string + " == null) {");
        this.outputStream.println("             ModelUtil.removeAllPropertyValues(getConfiguration().getModel(),getConfiguration().getDescribedUri()," + string5 + "." + string + ");");
        this.outputStream.println("         } else {");
        this.outputStream.println("             ModelUtil.removeAllPropertyValues(getConfiguration().getModel(),getConfiguration().getDescribedUri()," + string5 + "." + string + ");");
        this.outputStream.println("             for(" + string4 + " value : " + string + ") {");
        this.outputStream.println("                 getConfiguration().add(" + string5 + "." + string + ",value);");
        this.outputStream.println("             }");
        this.outputStream.println("         }");
        this.outputStream.println("     }");
    }

    private void generateEnumProperty(String string, String string2, String string3, String string4, URI uRI) {
        String string5;
        Map.Entry<String, String> entry;
        Node node = ModelUtil.getPropertyValue(this.myModel, (Resource)uRI, RDFS.range);
        URI uRI2 = node != null ? node.asURI() : null;
        String string6 = this.getLocalName(uRI2.toString());
        Map<String, String> map = this.getValuesMap(uRI, this.myModel);
        this.outputStream.println();
        this.outputStream.println("    /**");
        this.outputStream.println("     * Enum of possible values of the " + string + " property");
        this.outputStream.println("     */");
        this.outputStream.println("     public static enum " + string6 + " {");
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string5 = this.getLocalName(entry.getKey());
            this.outputStream.println("         /** Constant representing " + entry.getKey() + "*/");
            this.outputStream.println("         " + string5 + (iterator.hasNext() ? "," : ";"));
        }
        this.outputStream.println();
        this.outputStream.println("         public static " + string6 + " fromUri(URI uri) {");
        iterator = set.iterator();
        if (iterator.hasNext()) {
            entry = iterator.next();
            string5 = this.getLocalName(entry.getKey());
            System.out.println("A ku ku ");
            this.outputStream.println("             if (uri == null) {");
            this.outputStream.println("                 return null;");
            this.outputStream.println("             }");
            this.outputStream.println("             else if (uri.equals(" + string4 + "." + string5 + ")) {");
            this.outputStream.println("                 return " + string5 + ";");
            this.outputStream.println("             }");
            while (iterator.hasNext()) {
                entry = iterator.next();
                string5 = this.getLocalName(entry.getKey());
                this.outputStream.println("             else if (uri.equals(" + string4 + "." + string5 + ")) {");
                this.outputStream.println("                 return " + string5 + ";");
                this.outputStream.println("             }");
            }
            this.outputStream.println("             else {");
            this.outputStream.println("                 return null;");
            this.outputStream.println("             }");
        }
        this.outputStream.println("         }");
        this.outputStream.println("         public URI toUri() {");
        iterator = set.iterator();
        if (iterator.hasNext()) {
            entry = iterator.next();
            string5 = this.getLocalName(entry.getKey());
            this.outputStream.println("             if (this.equals(" + string5 + ")) {");
            this.outputStream.println("                 return " + string4 + "." + string5 + ";");
            this.outputStream.println("             }");
            while (iterator.hasNext()) {
                entry = iterator.next();
                string5 = this.getLocalName(entry.getKey());
                this.outputStream.println("             else if (this.equals(" + string5 + ")) {");
                this.outputStream.println("                 return " + string4 + "." + string5 + ";");
                this.outputStream.println("             }");
            }
            this.outputStream.println("             else {");
            this.outputStream.println("                 return null;");
            this.outputStream.println("             }");
        }
        this.outputStream.println("         }");
        this.outputStream.println("     }");
        this.outputStream.println();
        this.outputStream.println("    /**");
        this.outputStream.println("     * Returns the " + string3);
        this.outputStream.println("     * ");
        this.outputStream.println("     * @return the " + string3 + " or null if no value has been set");
        this.outputStream.println("     * @throws NullPointerException if no configuration has been set, use");
        this.outputStream.println("     *             {@link #setConfiguration(RDFContainer)} before calling this method");
        this.outputStream.println("     */");
        this.outputStream.println("     public " + string6 + " get" + string2 + "() {");
        this.outputStream.println("          return " + string6 + ".fromUri(getConfiguration().getURI(" + string4 + "." + string + "));");
        this.outputStream.println("     }");
        this.outputStream.println();
        this.outputStream.println();
        this.outputStream.println("    /**");
        this.outputStream.println("     * Sets the " + string3);
        this.outputStream.println("     * ");
        this.outputStream.println("     * @param " + string + " " + string3 + ", can be null in which case any previous setting will be removed");
        this.outputStream.println("     * @throws NullPointerException if no configuration has been set, use");
        this.outputStream.println("     *             {@link #setConfiguration(RDFContainer)} before calling this method");
        this.outputStream.println("     */");
        this.outputStream.println("     public void set" + string2 + "(" + string6 + " " + string + ") {");
        this.outputStream.println("         if ( " + string + " == null) {");
        this.outputStream.println("             getConfiguration().remove(" + string4 + "." + string + ");");
        this.outputStream.println("         } else {");
        this.outputStream.println("             getConfiguration().put(" + string4 + "." + string + "," + string + ".toUri());");
        this.outputStream.println("         }");
        this.outputStream.println("     }");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI getWidgetType(URI uRI) {
        String string = "PREFIX fresnel: " + FRESNEL.NS_FRESNEL.toSPARQL() + "\n " + "PREFIX sourceformat: " + SOURCEFORMAT.NS_SOURCEFORMAT.toSPARQL() + "\n " + "PREFIX rdf: <" + "http://www.w3.org/1999/02/22-rdf-syntax-ns#" + ">\n " + "SELECT ?x " + "WHERE { ?y fresnel:propertyFormatDomain " + uRI.toSPARQL() + " . " + "        ?y sourceformat:valueWidget ?z . " + "        ?z rdf:type ?x . }";
        ClosableIterator closableIterator = null;
        try {
            QueryResultTable queryResultTable = this.myModel.sparqlSelect(string);
            closableIterator = queryResultTable.iterator();
            if (closableIterator.hasNext()) {
                QueryRow queryRow = (QueryRow)closableIterator.next();
                URI uRI2 = (URI)queryRow.getValue("x");
                if (uRI2 != null) {
                    URI uRI3 = uRI2;
                    return uRI3;
                }
                log.error("The widget for " + uRI + " has a type that is not an uri");
            } else {
                log.warn("No widget found for " + uRI);
            }
        }
        finally {
            closableIterator.close();
        }
        return null;
    }

    private String getVocabularyClassName(URI uRI) {
        if (uRI.toString().startsWith(DATASOURCE.NS_DATASOURCE.toString())) {
            return DATASOURCE.class.getName();
        }
        return this.vocabularyClassName;
    }

    private String getJavaRangeType(URI uRI) {
        if (uRI == null || uRI.equals(RDFS.Literal) || uRI.equals(XSD._string)) {
            return "String";
        }
        if (uRI.equals(XSD._int) || uRI.equals(XSD._integer)) {
            return "Integer";
        }
        if (uRI.equals(XSD._long)) {
            return "Long";
        }
        if (uRI.equals(XSD._boolean)) {
            return "Boolean";
        }
        if (uRI.equals(DATASOURCE.Pattern)) {
            return "DomainBoundaries";
        }
        return "URI";
    }

    private String getLocalName(String string) {
        String string2 = string.toString();
        int n = string2.indexOf(35);
        if (n < 0) {
            n = string2.lastIndexOf(47);
        }
        if (n < 0) {
            n = string2.lastIndexOf(58);
        }
        if (n < 0) {
            throw new RuntimeException("Not a legal (absolute) URI: " + string2);
        }
        return string2.substring(n + 1);
    }

    private void getOpt(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            this.help();
            throw new Exception("no arguments given");
        }
        for (int i = 0; i < stringArray.length && stringArray[i].startsWith("-"); ++i) {
            if (stringArray[i].equals("-i")) {
                this.inputRdfFilePath = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-o")) {
                this.outputDirectoryPath = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-c")) {
                this.classUri = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-n")) {
                this.vocabularyClassName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--package")) {
                this.packageName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-f")) {
                this.forceGeneration = true;
                continue;
            }
            if (stringArray[i].equals("-namespacestrict")) {
                String string;
                if ("false".equals(string = stringArray[++i])) {
                    this.namespacestrict = false;
                    continue;
                }
                if ("true".equals(string)) {
                    this.namespacestrict = true;
                    continue;
                }
                throw new Exception("namespacestrict only allows 'true' or 'false', not '" + string + "'");
            }
            throw new Exception("unknow argument " + stringArray[i]);
        }
        this.outputFileName = this.getLocalName(this.classUri);
        if (this.inputRdfFilePath == null) {
            DataSourceClassGenerator.usage("no input file given");
        }
        if (this.outputDirectoryPath == null) {
            DataSourceClassGenerator.usage("no output dir given");
        }
        if (this.classUri == null) {
            DataSourceClassGenerator.usage("no class uri given");
        }
        if (this.packageName == null) {
            DataSourceClassGenerator.usage("no package name given");
        }
        this.inputRdfFile = new File(this.inputRdfFilePath);
        if (!this.inputRdfFile.canRead()) {
            DataSourceClassGenerator.usage("cannot read the input file");
        }
        this.outputDirFile = new File(this.outputDirectoryPath);
        if (!this.outputDirFile.canWrite()) {
            DataSourceClassGenerator.usage("cannot write to the output directory");
        }
        this.outputFile = new File(this.outputDirectoryPath, this.outputFileName + ".java");
    }

    private void help() {
        System.err.println("Syntax: java VocabularyWriter -i inputfile -o outputdir -c classuri --package package ");
    }

    public static void main(String[] stringArray) throws Exception {
        new DataSourceClassGenerator().go(stringArray);
    }

    protected String asLegalJavaID(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        try {
            while (!Character.isJavaIdentifierStart(string.charAt(n))) {
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println("Could not identify legal Java identifier start character in '" + string + "', replacing with __");
            return "__";
        }
        stringBuilder.append(bl ? Character.toUpperCase(string.charAt(n)) : string.charAt(n));
        ++n;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuilder.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
            ++n;
        }
        String string2 = stringBuilder.toString();
        if (JAVA_RESERVED_WORDS_SET.contains(string2)) {
            string2 = string2 + "_";
        }
        return string2;
    }

    private static void usage(String string) throws Exception {
        throw new Exception(string);
    }

    private URI getFresnelLensURI(Model model, String string) {
        URIImpl uRIImpl = new URIImpl(string);
        try {
            Resource resource = ModelUtil.getSingleSubjectWithProperty(model, FRESNEL.classLensDomain, (Node)uRIImpl);
            if (resource != null) {
                return resource.asURI();
            }
            return null;
        }
        catch (ClassCastException classCastException) {
            log.warn("Couldn't fetch the fresnel lens uri", (Throwable)classCastException);
            return null;
        }
    }

    private List<URI> getConfigurationOptionsList(URI uRI) {
        LinkedList<URI> linkedList = new LinkedList<URI>();
        try {
            Resource resource = ModelUtil.getPropertyValue(this.myModel, (Resource)uRI, FRESNEL.showProperties).asResource();
            while (!resource.equals(RDF.nil)) {
                URI uRI2 = ModelUtil.getPropertyValue(this.myModel, resource, RDF.first).asURI();
                linkedList.add(uRI2);
                if (uRI2.equals(DATASOURCE.includePattern) || uRI2.equals(DATASOURCE.excludePattern)) {
                    this.domainBoundableDataSource = true;
                }
                resource = ModelUtil.getPropertyValue(this.myModel, resource, RDF.rest).asResource();
            }
            return linkedList;
        }
        catch (ClassCastException classCastException) {
            log.warn("Couldn't fetch the list of the configuration options", (Throwable)classCastException);
            return null;
        }
    }

    private Map<String, String> getValuesMap(URI uRI, Model model) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        URI uRI2 = ModelUtil.getSingleSubjectWithProperty(this.myModel, FRESNEL.propertyFormatDomain, (Node)uRI).asURI();
        try {
            Resource resource = ModelUtil.getPropertyValue(model, (Resource)uRI2, SOURCEFORMAT.valueWidget).asResource();
            List<Node> list = ModelUtil.getAllPropertyValues(model, resource, SOURCEFORMAT.hasEntry);
            for (Node node : list) {
                Resource resource2 = node.asResource();
                Node node2 = ModelUtil.getPropertyValue(model, resource2, SOURCEFORMAT.label);
                Node node3 = ModelUtil.getPropertyValue(model, resource2, SOURCEFORMAT.value);
                treeMap.put(node3.toString(), node2.toString());
            }
        }
        catch (ClassCastException classCastException) {
            log.warn("Couldn't get the values map", (Throwable)classCastException);
        }
        return treeMap;
    }
}

