/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.flickr;

import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.datasource.base.DataSourceBase;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;
import org.semanticdesktop.aperture.websites.flickr.FLICKRDS;

public class FlickrDataSource
extends DataSourceBase {
    public URI getType() {
        return FLICKRDS.FlickrDataSource;
    }

    public String getUsername() {
        return this.getConfiguration().getString(DATASOURCE.username);
    }

    public void setUsername(String string) {
        if (string == null) {
            this.getConfiguration().remove(DATASOURCE.username);
        } else {
            this.getConfiguration().put(DATASOURCE.username, string);
        }
    }

    public String getPassword() {
        return this.getConfiguration().getString(DATASOURCE.password);
    }

    public void setPassword(String string) {
        if (string == null) {
            this.getConfiguration().remove(DATASOURCE.password);
        } else {
            this.getConfiguration().put(DATASOURCE.password, string);
        }
    }

    public CrawlType getCrawlType() {
        return CrawlType.fromUri(this.getConfiguration().getURI(FLICKRDS.crawlType));
    }

    public void setCrawlType(CrawlType crawlType) {
        if (crawlType == null) {
            this.getConfiguration().remove(FLICKRDS.crawlType);
        } else {
            this.getConfiguration().put(FLICKRDS.crawlType, (Node)crawlType.toUri());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CrawlType {
        ItemsAndTagsCrawlType,
        ItemsOnlyCrawlType;


        public static CrawlType fromUri(URI uRI) {
            if (uRI == null) {
                return null;
            }
            if (uRI.equals(FLICKRDS.ItemsAndTagsCrawlType)) {
                return ItemsAndTagsCrawlType;
            }
            if (uRI.equals(FLICKRDS.ItemsOnlyCrawlType)) {
                return ItemsOnlyCrawlType;
            }
            return null;
        }

        public URI toUri() {
            if (this.equals((Object)ItemsAndTagsCrawlType)) {
                return FLICKRDS.ItemsAndTagsCrawlType;
            }
            if (this.equals((Object)ItemsOnlyCrawlType)) {
                return FLICKRDS.ItemsOnlyCrawlType;
            }
            return null;
        }
    }
}

