/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.osgi;

import java.util.logging.Logger;
import org.ontoware.rdf2go.ModelFactory;
import org.ontoware.rdf2go.RDF2Go;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class RDF2GoActivator
implements BundleActivator,
ServiceListener {
    public static final String DEFAULTMODELFACTORY_CFG = "org.ontoware.rdf2go.defaultmodelfactory";
    private BundleContext bc;
    private String defaultFactoryClassName = null;
    private static final Logger log = Logger.getLogger(RDF2GoActivator.class.getName());

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.defaultFactoryClassName = context.getProperty(DEFAULTMODELFACTORY_CFG);
        if (this.defaultFactoryClassName == null) {
            log.warning("RDF2Go cannot find configuration value for default RDF2Go factory. No Default ModelFactory will be available. Please set org.ontoware.rdf2go.defaultmodelfactory");
        }
        String filter = "(objectclass=" + ModelFactory.class.getName() + ")";
        context.addServiceListener((ServiceListener)this, filter);
        ServiceReference[] references = context.getServiceReferences(null, filter);
        for (int i = 0; references != null && i < references.length; ++i) {
            this.serviceChanged(new ServiceEvent(1, references[i]));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bc = null;
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.defaultFactoryClassName == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                ModelFactory factory = (ModelFactory)this.bc.getService(event.getServiceReference());
                if (factory.getClass().getName().equals(this.defaultFactoryClassName)) {
                    log.info("RDF2Go uses " + this.defaultFactoryClassName + " as default ModelFactory");
                    RDF2Go.register(factory);
                    break;
                }
                this.bc.ungetService(event.getServiceReference());
                break;
            }
            case 4: {
                ModelFactory factory = (ModelFactory)this.bc.getService(event.getServiceReference());
                if (factory.getClass().getName().equals(this.defaultFactoryClassName)) {
                    log.fine("RDF2Go unregistered the ModelFactory " + this.defaultFactoryClassName + " as default ModelFactory. No ModelFactory available now. The Bundle of the ModelFactory was unregistered.");
                    RDF2Go.register((ModelFactory)null);
                }
                this.bc.ungetService(event.getServiceReference());
            }
        }
    }
}

