/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xsd;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.modeshape.graph.property.Path;

public class NamespaceEntityResolver {
    private final Map<String, Map<String, Target>> targetByNameByNamespace = new HashMap<String, Map<String, Target>>();
    private static final Target NullTarget = new Target(null, null);

    public void register(String namespace, String name, Path path, UUID uuid) {
        Map<String, Target> forNamespace = this.targetByNameByNamespace.get(namespace);
        if (forNamespace == null) {
            forNamespace = new HashMap<String, Target>();
            this.targetByNameByNamespace.put(namespace, forNamespace);
        }
        Target existing = forNamespace.put(name, new Target(path, uuid));
        assert (existing == null || existing.uuid.equals(uuid) && existing.path.equals(path));
    }

    public UUID lookup(String namespace, String name) {
        return this.doLookup((String)namespace, (String)name).uuid;
    }

    protected Target doLookup(String namespace, String name) {
        Map<String, Target> forNamespace = this.targetByNameByNamespace.get(namespace);
        if (forNamespace == null) {
            return NullTarget;
        }
        Target target = forNamespace.get(name);
        return target != null ? target : NullTarget;
    }

    protected static final class Target {
        protected final Path path;
        protected final UUID uuid;

        protected Target(Path path, UUID uuid) {
            this.path = path;
            this.uuid = uuid;
        }
    }
}

