/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xsd;

import java.io.InputStream;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.xsd.XsdReader;

public class XsdSequencer
implements StreamSequencer {
    protected static final boolean TRACE = true;

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        assert (stream != null);
        assert (output != null);
        assert (context != null);
        Path pathToArchiveFile = context.getInputPath();
        Name xsdName = null;
        if (pathToArchiveFile != null && !pathToArchiveFile.isRoot()) {
            if (pathToArchiveFile.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
                pathToArchiveFile = pathToArchiveFile.getParent();
            }
            if (!pathToArchiveFile.isRoot()) {
                xsdName = pathToArchiveFile.getLastSegment().getName();
            }
        }
        assert (xsdName != null);
        Path docPath = context.getValueFactories().getPathFactory().createRelativePath(new Name[]{xsdName});
        new XsdReader(output, context).read(stream, docPath);
    }
}

