/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;

public final class ShingleAnalyzerWrapper
extends Analyzer {
    private final Analyzer defaultAnalyzer;
    private int maxShingleSize = 2;
    private int minShingleSize = 2;
    private String tokenSeparator = " ";
    private boolean outputUnigrams = true;
    private boolean outputUnigramsIfNoShingles = false;

    public ShingleAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public ShingleAnalyzerWrapper(Analyzer defaultAnalyzer, int maxShingleSize) {
        this(defaultAnalyzer);
        this.setMaxShingleSize(maxShingleSize);
    }

    public ShingleAnalyzerWrapper(Analyzer defaultAnalyzer, int minShingleSize, int maxShingleSize) {
        this(defaultAnalyzer);
        this.setMaxShingleSize(maxShingleSize);
        this.setMinShingleSize(minShingleSize);
    }

    public ShingleAnalyzerWrapper(Version matchVersion) {
        this.defaultAnalyzer = new StandardAnalyzer(matchVersion);
    }

    public ShingleAnalyzerWrapper(Version matchVersion, int minShingleSize, int maxShingleSize) {
        this(matchVersion);
        this.setMaxShingleSize(maxShingleSize);
        this.setMinShingleSize(minShingleSize);
    }

    public int getMaxShingleSize() {
        return this.maxShingleSize;
    }

    public void setMaxShingleSize(int maxShingleSize) {
        if (maxShingleSize < 2) {
            throw new IllegalArgumentException("Max shingle size must be >= 2");
        }
        this.maxShingleSize = maxShingleSize;
    }

    public int getMinShingleSize() {
        return this.minShingleSize;
    }

    public void setMinShingleSize(int minShingleSize) {
        if (minShingleSize < 2) {
            throw new IllegalArgumentException("Min shingle size must be >= 2");
        }
        if (minShingleSize > this.maxShingleSize) {
            throw new IllegalArgumentException("Min shingle size must be <= max shingle size");
        }
        this.minShingleSize = minShingleSize;
    }

    public String getTokenSeparator() {
        return this.tokenSeparator;
    }

    public void setTokenSeparator(String tokenSeparator) {
        this.tokenSeparator = tokenSeparator == null ? "" : tokenSeparator;
    }

    public boolean isOutputUnigrams() {
        return this.outputUnigrams;
    }

    public void setOutputUnigrams(boolean outputUnigrams) {
        this.outputUnigrams = outputUnigrams;
    }

    public boolean isOutputUnigramsIfNoShingles() {
        return this.outputUnigramsIfNoShingles;
    }

    public void setOutputUnigramsIfNoShingles(boolean outputUnigramsIfNoShingles) {
        this.outputUnigramsIfNoShingles = outputUnigramsIfNoShingles;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream wrapped;
        try {
            wrapped = this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
        }
        catch (IOException e) {
            wrapped = this.defaultAnalyzer.tokenStream(fieldName, reader);
        }
        ShingleFilter filter = new ShingleFilter(wrapped, this.minShingleSize, this.maxShingleSize);
        filter.setMinShingleSize(this.minShingleSize);
        filter.setMaxShingleSize(this.maxShingleSize);
        filter.setTokenSeparator(this.tokenSeparator);
        filter.setOutputUnigrams(this.outputUnigrams);
        filter.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
        return filter;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.wrapped = this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
            streams.shingle = new ShingleFilter(streams.wrapped);
            this.setPreviousTokenStream(streams);
        } else {
            TokenStream result = this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
            if (result != streams.wrapped) {
                streams.wrapped = result;
                streams.shingle = new ShingleFilter(streams.wrapped);
            }
        }
        streams.shingle.setMaxShingleSize(this.maxShingleSize);
        streams.shingle.setMinShingleSize(this.minShingleSize);
        streams.shingle.setTokenSeparator(this.tokenSeparator);
        streams.shingle.setOutputUnigrams(this.outputUnigrams);
        streams.shingle.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
        return streams.shingle;
    }

    private class SavedStreams {
        TokenStream wrapped;
        ShingleFilter shingle;

        private SavedStreams() {
        }
    }
}

