/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene.query;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueComparators;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.search.lucene.query.CaseOperations;
import org.modeshape.search.lucene.query.CompareQuery;

public class CompareNameQuery
extends CompareQuery<Path.Segment> {
    private static final long serialVersionUID = 1L;
    protected static final CompareQuery.Evaluator<Path.Segment> EQUAL_TO = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) == 0;
        }

        public String toString() {
            return " = ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_LESS_THAN = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) < 0;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_LESS_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) <= 0;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_GREATER_THAN = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) > 0;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_GREATER_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) >= 0;
        }

        public String toString() {
            return " >= ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> EQUAL_TO_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) == 0;
        }

        public String toString() {
            return " = ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_LESS_THAN_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) < 0;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_LESS_THAN_OR_EQUAL_TO_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) <= 0;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_GREATER_THAN_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) > 0;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_GREATER_THAN_OR_EQUAL_TO_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) >= 0;
        }

        public String toString() {
            return " >= ";
        }
    };
    private final String snsIndexFieldName;
    private final ValueFactory<Long> longFactory;
    private final PathFactory pathFactory;
    private final CaseOperations.CaseOperation caseOperation;

    public static Query createQueryForNodesWithNameEqualTo(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation, boolean includeSns) {
        if (caseOperation == CaseOperations.AS_IS) {
            String nameStr = (String)factories.getStringFactory().create(constraintValue.getName());
            TermQuery nameQuery = new TermQuery(new Term(localNameField, nameStr));
            if (includeSns) {
                int snsIndex = constraintValue.getIndex();
                BooleanQuery booleanQuery = new BooleanQuery();
                booleanQuery.add((Query)nameQuery, BooleanClause.Occur.MUST);
                booleanQuery.add((Query)NumericRangeQuery.newIntRange((String)snsIndexFieldName, (Integer)snsIndex, (Integer)snsIndex, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
                return booleanQuery;
            }
            return nameQuery;
        }
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<Long>)factories.getLongFactory(), includeSns ? EQUAL_TO : EQUAL_TO_NO_SNS, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameGreaterThan(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation, boolean includeSns) {
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<Long>)factories.getLongFactory(), includeSns ? IS_GREATER_THAN : IS_GREATER_THAN_NO_SNS, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameGreaterThanOrEqualTo(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation, boolean includeSns) {
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<Long>)factories.getLongFactory(), includeSns ? IS_GREATER_THAN_OR_EQUAL_TO : IS_GREATER_THAN_OR_EQUAL_TO_NO_SNS, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameLessThan(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation, boolean includeSns) {
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<Long>)factories.getLongFactory(), includeSns ? IS_LESS_THAN : IS_LESS_THAN_NO_SNS, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameLessThanOrEqualTo(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation, boolean includeSns) {
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<Long>)factories.getLongFactory(), includeSns ? IS_LESS_THAN_OR_EQUAL_TO : IS_LESS_THAN_OR_EQUAL_TO_NO_SNS, caseOperation);
    }

    protected CompareNameQuery(final String localNameField, final String snsIndexFieldName, Path.Segment constraintValue, PathFactory pathFactory, ValueFactory<String> stringFactory, ValueFactory<Long> longFactory, CompareQuery.Evaluator<Path.Segment> evaluator, CaseOperations.CaseOperation caseOperation) {
        super(localNameField, constraintValue, null, stringFactory, evaluator, new FieldSelector(){
            private static final long serialVersionUID = 1L;

            public FieldSelectorResult accept(String fieldName) {
                if (fieldName.equals(localNameField)) {
                    return FieldSelectorResult.LOAD;
                }
                if (fieldName.equals(snsIndexFieldName)) {
                    return FieldSelectorResult.LOAD;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        });
        this.snsIndexFieldName = snsIndexFieldName;
        this.longFactory = longFactory;
        this.pathFactory = pathFactory;
        this.caseOperation = caseOperation;
        assert (this.snsIndexFieldName != null);
        assert (this.longFactory != null);
    }

    @Override
    protected Path.Segment readFromDocument(IndexReader reader, int docId) throws IOException {
        Document doc = reader.document(docId, this.fieldSelector);
        String localName = doc.get(this.fieldName);
        localName = this.caseOperation.execute(localName);
        int sns = ((Long)this.longFactory.create(doc.get(this.snsIndexFieldName))).intValue();
        return this.pathFactory.createSegment(localName, sns);
    }

    public Object clone() {
        return new CompareNameQuery(this.fieldName, this.snsIndexFieldName, (Path.Segment)this.constraintValue, this.pathFactory, (ValueFactory<String>)this.stringFactory, this.longFactory, this.evaluator, this.caseOperation);
    }
}

