/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.api.ValueFactory;
import org.modeshape.jcr.api.mimetype.MimeTypeDetector;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;

public abstract class Sequencer {
    private String name;
    private String description;
    private String repositoryName;
    private Object[] pathExpressions;
    private String pathExpression;

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    public final String[] getPathExpressions() {
        String pathExpression = this.pathExpression;
        Object[] pathExpressions = this.pathExpressions;
        if (pathExpression != null && pathExpressions == null || pathExpressions.length == 0) {
            return new String[]{pathExpression};
        }
        ArrayList<String> expressions = new ArrayList<String>(pathExpressions.length + 1);
        this.addExpression(expressions, pathExpression);
        for (Object value : pathExpressions) {
            this.addExpression(expressions, value);
        }
        return expressions.toArray(new String[expressions.size()]);
    }

    private void addExpression(List<String> values, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if ((str = str.trim()).length() != 0) {
                values.add(str);
            }
        }
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
    }

    public abstract boolean execute(Property var1, Node var2, Context var3) throws Exception;

    public String toString() {
        return this.repositoryName + " -> " + this.name + (this.description != null ? " : " + this.description : "");
    }

    protected boolean registerNamespace(String namespacePrefix, String namespaceUri, NamespaceRegistry namespaceRegistry) throws RepositoryException {
        if (namespacePrefix == null || namespaceUri == null) {
            throw new IllegalArgumentException("Neither the namespace prefix, nor the uri should be null");
        }
        try {
            namespaceRegistry.getPrefix(namespaceUri);
            return false;
        }
        catch (NamespaceException e) {
            namespaceRegistry.registerNamespace(namespacePrefix, namespaceUri);
            return true;
        }
    }

    protected void registerNodeTypes(String cndFile, NodeTypeManager nodeTypeManager, boolean allowUpdate) throws RepositoryException, IOException {
        InputStream cndStream = this.getClass().getResourceAsStream(cndFile);
        this.registerNodeTypes(cndStream, nodeTypeManager, allowUpdate);
    }

    protected void registerNodeTypes(InputStream cndStream, NodeTypeManager nodeTypeManager, boolean allowUpdate) throws RepositoryException, IOException {
        if (cndStream == null) {
            throw new IllegalArgumentException("The stream to the given cnd file is null");
        }
        nodeTypeManager.registerNodeTypes(cndStream, allowUpdate);
    }

    public static interface Context {
        public Calendar getTimestamp();

        public ValueFactory valueFactory();

        public MimeTypeDetector mimeTypeDetector();
    }
}

