/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;

@NotThreadSafe
final class JcrMultiValueProperty
extends AbstractJcrProperty {
    static final JcrValue[] EMPTY_VALUES = new JcrValue[0];

    JcrMultiValueProperty(AbstractJcrNode node, Name name, int propertyType) {
        super(node, name, propertyType);
    }

    public boolean isMultiple() {
        return true;
    }

    public boolean getBoolean() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Calendar getDate() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public double getDouble() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public long getLength() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public long[] getLengths() throws RepositoryException {
        this.checkSession();
        JcrValue[] values = this.getValues();
        long[] lengths = new long[values.length];
        int ndx = 0;
        for (JcrValue value : values) {
            lengths[ndx++] = value.getLength();
        }
        return lengths;
    }

    public long getLong() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public InputStream getStream() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public String getString() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    @Override
    public JcrValue[] getValues() throws RepositoryException {
        this.checkSession();
        Property innerProp = this.property();
        JcrValue[] values = new JcrValue[innerProp.size()];
        Iterator iter = innerProp.iterator();
        int ndx = 0;
        while (iter.hasNext()) {
            values[ndx] = this.createValue(iter.next());
            ++ndx;
        }
        return values;
    }

    public final void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        Object[] literals = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            JcrValue value = (JcrValue)values[i];
            if (value != null) {
                if (value.value() == null) {
                    throw new ValueFormatException(JcrI18n.valueMayNotContainNull.text(new Object[]{this.getName()}));
                }
                literals[i] = value.asType(this.getType()).value();
                continue;
            }
            literals[i] = null;
        }
        Property newProperty = this.propertyFactory().create(this.name(), literals);
        this.mutable().setProperty(this.sessionCache(), newProperty);
    }

    public final void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        Property newProperty = null;
        if (values.length != 0) {
            int numValues = values.length;
            Object[] literals = new Object[numValues];
            for (int i = 0; i != numValues; ++i) {
                String value = values[i];
                if (value == null) {
                    literals[i] = null;
                    continue;
                }
                JcrValue jcrValue = this.createValue(values[i], 1).asType(this.getType());
                literals[i] = jcrValue.value();
            }
            newProperty = this.propertyFactory().create(this.name(), literals);
        }
        if (newProperty == null) {
            newProperty = this.propertyFactory().create(this.name());
        }
        this.mutable().setProperty(this.sessionCache(), newProperty);
    }

    @Override
    public JcrValue getValue() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Value value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(String value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(InputStream value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(long value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(double value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Calendar value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(boolean value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Node value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Binary getBinary() throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public javax.jcr.Property getProperty() throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public void setValue(BigDecimal value) throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public void setValue(Binary value) throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }
}

