/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.change;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.Observable;

@ThreadSafe
public class MultiplexingChangeSetListener
implements ChangeSetListener,
Observable {
    private final Set<ChangeSetListener> delegates = new CopyOnWriteArraySet<ChangeSetListener>();

    @Override
    public boolean register(ChangeSetListener listener) {
        return listener != null ? this.delegates.add(listener) : false;
    }

    @Override
    public boolean unregister(ChangeSetListener listener) {
        return listener != null ? this.delegates.remove(listener) : false;
    }

    @Override
    public void notify(ChangeSet changeSet) {
        for (ChangeSetListener listener : this.delegates) {
            listener.notify(changeSet);
        }
    }
}

