/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.value.Path;

@Immutable
public interface QueryResults
extends Serializable {
    public static final ThreadLocal<DecimalFormat> FORMATTER = new ThreadLocal<DecimalFormat>(){

        @Override
        protected synchronized DecimalFormat initialValue() {
            return new DecimalFormat("###,###,##0.0##");
        }
    };

    public Columns getColumns();

    public Cursor getCursor();

    public List<Object[]> getTuples();

    public int getRowCount();

    public String getPlan();

    public Problems getProblems();

    public boolean hasErrors();

    public boolean hasWarnings();

    public Statistics getStatistics();

    public static final class Location
    implements Comparable<Location> {
        static Comparator<Location> COMPARATOR = new Comparator<Location>(){

            @Override
            public int compare(Location o1, Location o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        };
        private final Path path;
        private final NodeKey key;

        public static Comparator<Location> getComparator() {
            return COMPARATOR;
        }

        public Location(Path path) {
            this.path = path;
            this.key = null;
        }

        public Location(Path path, NodeKey key) {
            this.path = path;
            this.key = key;
        }

        public Path getPath() {
            return this.path;
        }

        public NodeKey getKey() {
            return this.key;
        }

        public boolean isSame(Location that) {
            return this.compareTo(that) == 0;
        }

        @Override
        public int compareTo(Location that) {
            if (this == that) {
                return 0;
            }
            return this.getPath().compareTo(that.getPath());
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Location) {
                Location that = (Location)obj;
                return this.getPath().equals(that.getPath());
            }
            return false;
        }
    }

    @Immutable
    public static class Statistics
    implements Comparable<Statistics>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Statistics EMPTY_STATISTICS = new Statistics();
        private final long planningNanos;
        private final long optimizationNanos;
        private final long resultFormulationNanos;
        private final long executionNanos;

        public Statistics() {
            this(0L, 0L, 0L, 0L);
        }

        public Statistics(long planningNanos) {
            this(planningNanos, 0L, 0L, 0L);
        }

        public Statistics(long planningNanos, long optimizationNanos, long resultFormulationNanos, long executionNanos) {
            this.planningNanos = planningNanos;
            this.optimizationNanos = optimizationNanos;
            this.resultFormulationNanos = resultFormulationNanos;
            this.executionNanos = executionNanos;
        }

        public long getPlanningTime(TimeUnit unit) {
            CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
            return unit.convert(this.planningNanos, TimeUnit.NANOSECONDS);
        }

        public long getOptimizationTime(TimeUnit unit) {
            CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
            return unit.convert(this.optimizationNanos, TimeUnit.NANOSECONDS);
        }

        public long getResultFormulationTime(TimeUnit unit) {
            CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
            return unit.convert(this.resultFormulationNanos, TimeUnit.NANOSECONDS);
        }

        public long getExecutionTime(TimeUnit unit) {
            return unit.convert(this.executionNanos, TimeUnit.NANOSECONDS);
        }

        public long getTotalTime(TimeUnit unit) {
            return unit.convert(this.totalTime(), TimeUnit.NANOSECONDS);
        }

        protected long totalTime() {
            return this.planningNanos + this.optimizationNanos + this.resultFormulationNanos + this.executionNanos;
        }

        public Statistics withPlanningTime(long planningNanos) {
            CheckArg.isNonNegative((long)planningNanos, (String)"planningNanos");
            return new Statistics(planningNanos, this.optimizationNanos, this.resultFormulationNanos, this.executionNanos);
        }

        public Statistics withOptimizationTime(long optimizationNanos) {
            CheckArg.isNonNegative((long)optimizationNanos, (String)"optimizationNanos");
            return new Statistics(this.planningNanos, optimizationNanos, this.resultFormulationNanos, this.executionNanos);
        }

        public Statistics withResultsFormulationTime(long resultFormulationNanos) {
            CheckArg.isNonNegative((long)resultFormulationNanos, (String)"resultFormulationNanos");
            return new Statistics(this.planningNanos, this.optimizationNanos, resultFormulationNanos, this.executionNanos);
        }

        public Statistics withExecutionTime(long executionNanos) {
            CheckArg.isNonNegative((long)executionNanos, (String)"executionNanos");
            return new Statistics(this.planningNanos, this.optimizationNanos, this.resultFormulationNanos, executionNanos);
        }

        public Statistics withPlanningTime(long planning, TimeUnit unit) {
            CheckArg.isNonNegative((long)planning, (String)"planning");
            CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
            long planningNanos = TimeUnit.NANOSECONDS.convert(planning, unit);
            return new Statistics(planningNanos, this.optimizationNanos, this.resultFormulationNanos, this.executionNanos);
        }

        public Statistics withOptimizationTime(long optimization, TimeUnit unit) {
            CheckArg.isNonNegative((long)optimization, (String)"optimization");
            CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
            long optimizationNanos = TimeUnit.NANOSECONDS.convert(optimization, unit);
            return new Statistics(this.planningNanos, optimizationNanos, this.resultFormulationNanos, this.executionNanos);
        }

        public Statistics withResultsFormulationTime(long resultFormulation, TimeUnit unit) {
            CheckArg.isNonNegative((long)resultFormulation, (String)"resultFormulation");
            CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
            long resultFormulationNanos = TimeUnit.NANOSECONDS.convert(resultFormulation, unit);
            return new Statistics(this.planningNanos, this.optimizationNanos, resultFormulationNanos, this.executionNanos);
        }

        public Statistics withExecutionTime(long execution, TimeUnit unit) {
            CheckArg.isNonNegative((long)execution, (String)"execution");
            CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
            long executionNanos = TimeUnit.NANOSECONDS.convert(execution, unit);
            return new Statistics(this.planningNanos, this.optimizationNanos, this.resultFormulationNanos, executionNanos);
        }

        @Override
        public int compareTo(Statistics that) {
            if (that == this) {
                return 0;
            }
            long diff = this.totalTime() - that.totalTime();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.readable(this.totalTime(), sb);
            boolean first = false;
            if (this.planningNanos != 0L) {
                sb.append(" (plan=");
                this.readable(this.planningNanos, sb);
                first = false;
            }
            if (this.optimizationNanos != 0L) {
                if (first) {
                    first = false;
                    sb.append(" (");
                } else {
                    sb.append(" ,");
                }
                sb.append("opt=");
                this.readable(this.optimizationNanos, sb);
            }
            if (this.resultFormulationNanos != 0L) {
                if (first) {
                    first = false;
                    sb.append(" (");
                } else {
                    sb.append(" ,");
                }
                sb.append("res=");
                this.readable(this.resultFormulationNanos, sb);
            }
            if (this.executionNanos != 0L) {
                if (first) {
                    first = false;
                    sb.append(" (");
                } else {
                    sb.append(" ,");
                }
                sb.append("exec=");
                this.readable(this.executionNanos, sb);
            }
            if (!first) {
                sb.append(')');
            }
            return sb.toString();
        }

        protected void readable(long nanos, StringBuilder sb) {
            if (nanos < 1000L) {
                sb.append(nanos).append(" ns");
            } else if (nanos < 1000000L) {
                double value = (double)nanos / 1000.0;
                sb.append(FORMATTER.get().format(value)).append(" usec");
            } else if (nanos < 1000000000L) {
                double value = (double)nanos / 1000000.0;
                sb.append(FORMATTER.get().format(value)).append(" ms");
            } else {
                double value = (double)nanos / 1.0E9;
                sb.append(FORMATTER.get().format(value)).append(" sec");
            }
        }
    }

    @Immutable
    public static interface Columns
    extends Serializable,
    Iterable<Column> {
        public List<? extends Column> getColumns();

        public List<String> getColumnNames();

        public List<String> getColumnTypes();

        public int getColumnCount();

        public int getLocationCount();

        public List<String> getSelectorNames();

        public int getTupleSize();

        public List<String> getTupleValueNames();

        public int getLocationIndexForColumn(int var1);

        public int getLocationIndexForColumn(String var1);

        public int getLocationIndex(String var1);

        public boolean hasSelector(String var1);

        public String getPropertyNameForColumn(int var1);

        public String getPropertyNameForColumnName(String var1);

        public int getColumnIndexForName(String var1);

        public String getSelectorNameForColumnName(String var1);

        public int getColumnIndexForProperty(String var1, String var2);

        public int getFullTextSearchScoreIndexFor(String var1);

        public boolean hasFullTextSearchScores();

        public boolean includes(Columns var1);

        public boolean isUnionCompatible(Columns var1);

        public Columns subSelect(List<Column> var1);

        public Columns subSelect(Column ... var1);

        public Columns joinWith(Columns var1);
    }

    public static interface Cursor {
        public boolean hasNext();

        public void next();

        public int getRowIndex();

        public Location getLocation(int var1);

        public Location getLocation(String var1);

        public Object getValue(int var1);

        public Object getValue(String var1);
    }
}

