/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.validate;

import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.AllNodes;
import org.modeshape.jcr.query.model.ArithmeticOperand;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.ChildNodeJoinCondition;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DescendantNodeJoinCondition;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.EquiJoinCondition;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.FullTextSearchScore;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.NamedSelector;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodeLocalName;
import org.modeshape.jcr.query.model.NodeName;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.Ordering;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.Query;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SameNodeJoinCondition;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.Subquery;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.query.model.Visitors;
import org.modeshape.jcr.query.validate.Schemata;

public class Validator
extends Visitors.AbstractVisitor {
    private final QueryContext context;
    private final Problems problems;
    private final Map<SelectorName, Schemata.Table> selectorsByNameOrAlias;
    private final Map<SelectorName, Schemata.Table> selectorsByName;
    private final Map<String, Schemata.Column> columnsByAlias;
    private final boolean validateColumnExistence;

    public Validator(QueryContext context, Map<SelectorName, Schemata.Table> selectorsByName) {
        this.context = context;
        this.problems = this.context.getProblems();
        this.selectorsByNameOrAlias = selectorsByName;
        this.selectorsByName = new HashMap<SelectorName, Schemata.Table>();
        for (Schemata.Table table : selectorsByName.values()) {
            this.selectorsByName.put(table.getName(), table);
        }
        this.columnsByAlias = new HashMap<String, Schemata.Column>();
        this.validateColumnExistence = context.getHints().validateColumnExistance;
    }

    @Override
    public void visit(AllNodes obj) {
        this.verifyTable(obj.name());
    }

    @Override
    public void visit(ArithmeticOperand obj) {
        this.verifyArithmeticOperand(obj.getLeft());
        this.verifyArithmeticOperand(obj.getRight());
    }

    protected void verifyArithmeticOperand(DynamicOperand operand) {
        if (!(operand instanceof NodeDepth || operand instanceof Length || operand instanceof ArithmeticOperand || operand instanceof FullTextSearchScore)) {
            if (operand instanceof PropertyValue) {
                String propertyName;
                PropertyValue value = (PropertyValue)operand;
                SelectorName selector = value.selectorName();
                Schemata.Column column = this.verify(selector, propertyName = value.getPropertyName(), this.validateColumnExistence);
                if (column != null) {
                    String columnType = column.getPropertyType();
                    TypeSystem types = this.context.getTypeSystem();
                    String longType = types.getLongFactory().getTypeName();
                    String doubleType = types.getDoubleFactory().getTypeName();
                    if (!longType.equals(types.getCompatibleType(columnType, longType)) && !doubleType.equals(types.getCompatibleType(columnType, doubleType))) {
                        I18n msg = GraphI18n.columnTypeCannotBeUsedInArithmeticOperation;
                        this.problems.addError(msg, new Object[]{selector, propertyName, columnType});
                    }
                }
            } else {
                I18n msg = GraphI18n.dynamicOperandCannotBeUsedInArithmeticOperation;
                this.problems.addError(msg, new Object[]{operand});
            }
        }
    }

    @Override
    public void visit(ChildNode obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(ChildNodeJoinCondition obj) {
        this.verify(obj.parentSelectorName());
        this.verify(obj.childSelectorName());
    }

    @Override
    public void visit(Column obj) {
        this.verify(obj.selectorName(), obj.getPropertyName(), this.validateColumnExistence);
    }

    @Override
    public void visit(Comparison obj) {
        this.verifyOperator(obj.getOperand1(), obj.operator());
    }

    @Override
    public void visit(DescendantNode obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(DescendantNodeJoinCondition obj) {
        this.verify(obj.ancestorSelectorName());
        this.verify(obj.descendantSelectorName());
    }

    @Override
    public void visit(EquiJoinCondition obj) {
        this.verify(obj.selector1Name(), obj.getProperty1Name(), this.validateColumnExistence);
        this.verify(obj.selector2Name(), obj.getProperty2Name(), this.validateColumnExistence);
    }

    @Override
    public void visit(FullTextSearch obj) {
        SelectorName selectorName = obj.selectorName();
        if (obj.getPropertyName() != null) {
            Schemata.Column column = this.verify(selectorName, obj.getPropertyName(), this.validateColumnExistence);
            if (column != null && !column.isFullTextSearchable()) {
                this.problems.addError(GraphI18n.columnIsNotFullTextSearchable, new Object[]{column.getName(), selectorName});
            }
        } else {
            Schemata.Table table = this.verify(selectorName);
            if (table != null && !AllNodes.ALL_NODES_NAME.equals(table.getName())) {
                boolean searchable = false;
                for (Schemata.Column column : table.getColumns()) {
                    if (!column.isFullTextSearchable()) continue;
                    searchable = true;
                    break;
                }
                if (!searchable) {
                    this.problems.addError(GraphI18n.tableIsNotFullTextSearchable, new Object[]{selectorName});
                }
            }
        }
    }

    @Override
    public void visit(FullTextSearchScore obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(Length obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(LowerCase obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(NamedSelector obj) {
        this.verify(obj.aliasOrName());
    }

    @Override
    public void visit(NodeDepth obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(NodeLocalName obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(NodeName obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(NodePath obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(Ordering obj) {
        this.verifyOrdering(obj.getOperand());
    }

    @Override
    public void visit(PropertyExistence obj) {
        this.verify(obj.selectorName(), obj.getPropertyName(), this.validateColumnExistence);
    }

    @Override
    public void visit(PropertyValue obj) {
        this.verify(obj.selectorName(), obj.getPropertyName(), this.validateColumnExistence);
    }

    @Override
    public void visit(ReferenceValue obj) {
        String propName = obj.getPropertyName();
        if (propName != null) {
            this.verify(obj.selectorName(), propName, this.validateColumnExistence);
        } else {
            this.verify(obj.selectorName());
        }
    }

    @Override
    public void visit(Query obj) {
        this.columnsByAlias.clear();
        for (Column column : obj.columns()) {
            Schemata.Column tableColumn;
            Schemata.Table table = this.tableWithNameOrAlias(column.selectorName());
            if (table == null || (tableColumn = table.getColumn(column.getPropertyName())) == null) continue;
            this.columnsByAlias.put(column.getColumnName(), tableColumn);
        }
        super.visit(obj);
    }

    @Override
    public void visit(Subquery subquery) {
    }

    @Override
    public void visit(SameNode obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(SameNodeJoinCondition obj) {
        this.verify(obj.selector1Name());
        this.verify(obj.selector2Name());
    }

    protected void verifyOrdering(DynamicOperand operand) {
        if (operand instanceof PropertyValue) {
            PropertyValue propValue = (PropertyValue)operand;
            this.verifyOrdering(propValue.selectorName(), propValue.getPropertyName());
        } else if (operand instanceof ReferenceValue) {
            ReferenceValue value = (ReferenceValue)operand;
            this.verifyOrdering(value.selectorName(), value.getPropertyName());
        } else if (operand instanceof Length) {
            Length length = (Length)operand;
            this.verifyOrdering(length.getPropertyValue());
        } else if (operand instanceof LowerCase) {
            this.verifyOrdering(((LowerCase)operand).getOperand());
        } else if (operand instanceof UpperCase) {
            this.verifyOrdering(((UpperCase)operand).getOperand());
        } else if (operand instanceof ArithmeticOperand) {
            ArithmeticOperand arith = (ArithmeticOperand)operand;
            this.verifyOrdering(arith.getLeft());
            this.verifyOrdering(arith.getRight());
        }
    }

    protected void verifyOrdering(SelectorName selectorName, String propertyName) {
        Schemata.Column column = this.verify(selectorName, propertyName, false);
        if (column != null && !column.isOrderable()) {
            this.problems.addError(GraphI18n.columnInTableIsNotOrderable, new Object[]{propertyName, selectorName.getString()});
        }
    }

    protected void verifyOperator(DynamicOperand operand, Operator op) {
        if (operand instanceof PropertyValue) {
            PropertyValue propValue = (PropertyValue)operand;
            this.verifyOperator(propValue.selectorName(), propValue.getPropertyName(), op);
        } else if (operand instanceof ReferenceValue) {
            ReferenceValue value = (ReferenceValue)operand;
            this.verifyOperator(value.selectorName(), value.getPropertyName(), op);
        } else if (operand instanceof Length) {
            Length length = (Length)operand;
            this.verifyOperator(length.getPropertyValue(), op);
        } else if (operand instanceof LowerCase) {
            this.verifyOperator(((LowerCase)operand).getOperand(), op);
        } else if (operand instanceof UpperCase) {
            this.verifyOperator(((UpperCase)operand).getOperand(), op);
        } else if (operand instanceof ArithmeticOperand) {
            ArithmeticOperand arith = (ArithmeticOperand)operand;
            this.verifyOperator(arith.getLeft(), op);
            this.verifyOperator(arith.getRight(), op);
        }
    }

    protected void verifyOperator(SelectorName selectorName, String propertyName, Operator op) {
        Schemata.Column column = this.verify(selectorName, propertyName, false);
        if (column != null && !column.getOperators().contains(op)) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Operator allowed : column.getOperators()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(allowed.symbol());
            }
            this.problems.addError(GraphI18n.operatorIsNotValidAgainstColumnInTable, new Object[]{op.symbol(), propertyName, selectorName.getString(), sb});
        }
    }

    protected Schemata.Table tableWithNameOrAlias(SelectorName tableName) {
        Schemata.Table table = this.selectorsByNameOrAlias.get(tableName);
        if (table == null) {
            table = this.selectorsByName.get(tableName);
        }
        return table;
    }

    protected Schemata.Table verify(SelectorName selectorName) {
        Schemata.Table table = this.tableWithNameOrAlias(selectorName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{selectorName.name()});
        }
        return table;
    }

    protected Schemata.Table verifyTable(SelectorName tableName) {
        Schemata.Table table = this.tableWithNameOrAlias(tableName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{tableName.name()});
        }
        return table;
    }

    protected Schemata.Column verify(SelectorName selectorName, String propertyName, boolean columnIsRequired) {
        Schemata.Table table = this.tableWithNameOrAlias(selectorName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{selectorName.name()});
            return null;
        }
        Schemata.Column column = table.getColumn(propertyName);
        if (column == null && (column = this.columnsByAlias.get(propertyName)) == null && !"*".equals(propertyName) && columnIsRequired && !table.hasExtraColumns()) {
            this.problems.addError(GraphI18n.columnDoesNotExistOnTable, new Object[]{propertyName, selectorName.name()});
        }
        return column;
    }
}

