/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.modeshape.jboss.Element;
import org.modeshape.jboss.ModeShapeAdd;
import org.modeshape.jboss.Namespace;
import org.modeshape.jboss.RepositoryAdd;
import org.modeshape.jboss.subsystem.JBossManagedI18n;

public class ModeShapeSubsystemDescribe
implements OperationStepHandler,
DescriptionProvider {
    public ModelNode getModelDescription(Locale locale) {
        ResourceBundle bundle = JBossManagedI18n.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set("modeshape subsystem");
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get("namespace").set(Namespace.CURRENT.getUri());
        ModeShapeAdd.describeModeShape(node, "attributes", bundle);
        node.get(new String[]{"children", Element.REPOSITORY_ELEMENT.getLocalName(), "description"}).set(Element.REPOSITORY_ELEMENT.getDescription(bundle));
        node.get(new String[]{"children", Element.REPOSITORY_ELEMENT.getLocalName(), "required"}).set(true);
        return node;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode result = context.getResult();
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode subModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode subsystemAdd = new ModelNode();
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(rootAddress.toModelNode());
        ModeShapeAdd.populate(subModel, subsystemAdd);
        result.add(subsystemAdd);
        if (subModel.hasDefined(Element.REPOSITORY_ELEMENT.getLocalName())) {
            for (Property container : subModel.get(Element.REPOSITORY_ELEMENT.getLocalName()).asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add(Element.REPOSITORY_ELEMENT.getLocalName(), container.getName());
                ModelNode addOperation = new ModelNode();
                addOperation.get("operation").set("add");
                addOperation.get("address").set(address);
                RepositoryAdd.populate(container.getValue(), addOperation);
                result.add(addOperation);
            }
        }
        context.completeStep();
    }
}

