/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.EncoderPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

@Provider
@ServerInterceptor
@ClientInterceptor
@EncoderPrecedence
public class GZIPEncodingInterceptor
implements MessageBodyWriterInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        Object encoding = context.getHeaders().getFirst("Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            OutputStream old = context.getOutputStream();
            CommittedGZIPOutputStream gzipOutputStream = new CommittedGZIPOutputStream(old, null);
            context.setOutputStream(gzipOutputStream);
            try {
                context.proceed();
            }
            finally {
                if (gzipOutputStream.getGzip() != null) {
                    gzipOutputStream.getGzip().finish();
                }
                context.setOutputStream(old);
            }
            return;
        }
        context.proceed();
    }

    private static class CommittedGZIPOutputStream
    extends CommitHeaderOutputStream {
        protected GZIPOutputStream gzip;

        protected CommittedGZIPOutputStream(OutputStream delegate, CommitHeaderOutputStream.CommitCallback headers) {
            super(delegate, headers);
        }

        public GZIPOutputStream getGzip() {
            return this.gzip;
        }

        @Override
        public void commit() {
            if (this.isHeadersCommitted) {
                return;
            }
            this.isHeadersCommitted = true;
            try {
                this.gzip = new EndableGZIPOutputStream(this.delegate);
                this.delegate = this.gzip;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class EndableGZIPOutputStream
    extends GZIPOutputStream {
        public EndableGZIPOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        @Override
        public void finish() throws IOException {
            super.finish();
            this.def.end();
        }
    }
}

