/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.PathSegment;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.registry.Segment;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.PathHelper;

public class PathParamSegment
extends Segment
implements Comparable<PathParamSegment> {
    protected String pathExpression;
    protected String regex;
    protected Pattern pattern;
    protected List<Group> groups = new ArrayList<Group>();
    protected int literalCharacters;
    protected int numCapturingGroups;
    protected int numNonDefaultGroups;
    public static final Pattern GROUP = Pattern.compile("[^\\\\]\\([^?]");

    @Override
    public int compareTo(PathParamSegment pathParamSegment) {
        if (this.literalCharacters > pathParamSegment.literalCharacters) {
            return -1;
        }
        if (this.literalCharacters < pathParamSegment.literalCharacters) {
            return 1;
        }
        if (this.numCapturingGroups > pathParamSegment.numCapturingGroups) {
            return -1;
        }
        if (this.numCapturingGroups < pathParamSegment.numCapturingGroups) {
            return 1;
        }
        if (this.numNonDefaultGroups > pathParamSegment.numNonDefaultGroups) {
            return -1;
        }
        if (this.numNonDefaultGroups < pathParamSegment.numNonDefaultGroups) {
            return 1;
        }
        return 0;
    }

    private static int groupCount(String regex) {
        regex = " " + regex;
        Matcher matcher = GROUP.matcher(regex);
        int groupCount = 0;
        while (matcher.find()) {
            ++groupCount;
        }
        return groupCount;
    }

    public PathParamSegment(String segment) {
        this.pathExpression = segment;
        String replacedCurlySegment = PathHelper.replaceEnclosedCurlyBraces(segment);
        this.literalCharacters = PathHelper.URI_PARAM_PATTERN.matcher(replacedCurlySegment).replaceAll("").length();
        String[] split = PathHelper.URI_PARAM_PATTERN.split(replacedCurlySegment);
        Matcher withPathParam = PathHelper.URI_PARAM_PATTERN.matcher(replacedCurlySegment);
        int i = 0;
        StringBuffer buffer = new StringBuffer();
        if (i < split.length) {
            buffer.append(Pattern.quote(split[i++]));
        }
        int groupNumber = 1;
        while (withPathParam.find()) {
            String name = withPathParam.group(1);
            buffer.append("(");
            if (withPathParam.group(3) == null) {
                buffer.append("[^/]+");
                this.groups.add(new Group(groupNumber++, name, true));
            } else {
                String expr = withPathParam.group(3);
                expr = PathHelper.recoverEnclosedCurlyBraces(expr);
                buffer.append(expr);
                ++this.numNonDefaultGroups;
                this.groups.add(new Group(groupNumber++, name));
                groupNumber += PathParamSegment.groupCount(expr);
            }
            buffer.append(")");
            if (i >= split.length) continue;
            buffer.append(Pattern.quote(split[i++]));
        }
        this.regex = buffer.toString();
        this.pattern = Pattern.compile(this.regex);
        this.numCapturingGroups = this.groups.size();
    }

    public String getRegex() {
        return this.regex;
    }

    public String getPathExpression() {
        return this.pathExpression;
    }

    protected void populatePathParams(HttpRequest request, Matcher matcher, String path) {
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        for (Group group : this.groups) {
            int i;
            String value = matcher.group(group.group);
            uriInfo.addEncodedPathParameter(group.name, value);
            int index = matcher.start(group.group);
            int start = 0;
            if (path.charAt(0) == '/') {
                ++start;
            }
            int segmentIndex = 0;
            if (start < path.length()) {
                int count = 0;
                for (i = start; i < index && i < path.length(); ++i) {
                    if (path.charAt(i) != '/') continue;
                    ++count;
                }
                segmentIndex = count;
            }
            int numSegments = 1;
            for (i = 0; i < value.length(); ++i) {
                if (value.charAt(i) != '/') continue;
                ++numSegments;
            }
            if (segmentIndex + numSegments > request.getUri().getPathSegments().size()) {
                throw new BadRequestException("Number of matched segments greater than actual");
            }
            PathSegment[] encodedSegments = new PathSegment[numSegments];
            PathSegment[] decodedSegments = new PathSegment[numSegments];
            for (int i2 = 0; i2 < numSegments; ++i2) {
                decodedSegments[i2] = request.getUri().getPathSegments().get(segmentIndex + i2);
                encodedSegments[i2] = request.getUri().getPathSegments(false).get(segmentIndex + i2);
            }
            uriInfo.getEncodedPathParameterPathSegments().add(group.name, encodedSegments);
            uriInfo.getPathParameterPathSegments().add(group.name, decodedSegments);
        }
    }

    public ResourceInvoker matchPattern(HttpRequest request, String path, int start) {
        String group0;
        int charAt;
        char c;
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        Matcher matcher = this.pattern.matcher(path);
        matcher.region(start, path.length());
        if (matcher.matches()) {
            ResourceInvoker invoker = this.match(request.getHttpMethod(), request);
            if (invoker == null) {
                throw new NotFoundException("Could not find resource for relative : " + path + " of full path: " + request.getUri().getRequestUri());
            }
            uriInfo.pushMatchedURI(path, Encode.decode(path));
            this.populatePathParams(request, matcher, path);
            return invoker;
        }
        if (this.locator == null) {
            throw new NotFoundException("Could not find resource for relative : " + path + " of full path: " + request.getUri().getRequestUri());
        }
        if (matcher.find(start) && matcher.start() == start && (c = path.charAt(charAt = start + (group0 = matcher.group(0)).length())) == '/') {
            String matched = path.substring(0, start + matcher.group(0).length());
            uriInfo.pushMatchedURI(matched, Encode.decode(matched));
            this.populatePathParams(request, matcher, path);
            return this.locator;
        }
        throw new NotFoundException("Could not find resource for relative : " + path + " of full path: " + request.getUri().getRequestUri());
    }

    public static int pathSegmentIndex(String string, int start, int stop) {
        if (start >= string.length()) {
            return 0;
        }
        int count = 0;
        for (int i = start; i < stop && i < string.length(); ++i) {
            if (string.charAt(i) != '/') continue;
            ++count;
        }
        return count;
    }

    private static class Group {
        int group;
        String name;
        boolean storePathSegment;

        private Group(int group, String name) {
            this.group = group;
            this.name = name;
        }

        private Group(int group, String name, boolean storePathSegment) {
            this.group = group;
            this.name = name;
            this.storePathSegment = storePathSegment;
        }
    }
}

