/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.net.URL;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.JsonNode;
import org.modeshape.web.jcr.rest.client.json.JsonUtils;
import org.modeshape.web.jcr.rest.client.json.WorkspaceNode;

@Immutable
public final class FolderNode
extends JsonNode {
    private static final long serialVersionUID = 1L;
    private final Workspace workspace;

    public FolderNode(Workspace workspace, String fullPath) throws Exception {
        super(fullPath);
        assert (workspace != null);
        assert (fullPath != null);
        this.workspace = workspace;
        JSONObject properties = new JSONObject();
        properties.put("jcr:primaryType", "nt:folder");
        this.put("properties", properties);
    }

    public String getPath() {
        return this.getId();
    }

    @Override
    public URL getUrl() throws Exception {
        WorkspaceNode workspaceNode = new WorkspaceNode(this.workspace);
        StringBuilder url = new StringBuilder(workspaceNode.getUrl().toString());
        String path = this.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        url.append(JsonUtils.encode(path));
        return new URL(url.toString());
    }
}

