/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.metadata;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.modeshape.jdbc.JcrType;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.metadata.MetadataProvider;
import org.modeshape.jdbc.metadata.ResultsMetadataConstants;

public class ResultSetMetaDataImpl
implements ResultSetMetaData {
    private MetadataProvider provider;

    public ResultSetMetaDataImpl(MetadataProvider provider) {
        this.provider = provider;
    }

    private int adjustColumn(int index) {
        return index - 1;
    }

    @Override
    public int getColumnCount() {
        return this.provider.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int index) {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.AUTO_INCREMENTING);
    }

    @Override
    public boolean isCaseSensitive(int index) {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.CASE_SENSITIVE);
    }

    @Override
    public boolean isSearchable(int index) {
        Integer searchable = (Integer)this.provider.getValue(this.adjustColumn(index), ResultsMetadataConstants.SEARCHABLE);
        return !ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE.equals(searchable);
    }

    @Override
    public boolean isCurrency(int index) {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.CURRENCY);
    }

    @Override
    public int isNullable(int index) {
        Object nullable = this.provider.getValue(this.adjustColumn(index), ResultsMetadataConstants.NULLABLE);
        if (nullable.equals(ResultsMetadataConstants.NULL_TYPES.NULLABLE)) {
            return 1;
        }
        if (nullable.equals(ResultsMetadataConstants.NULL_TYPES.NOT_NULL)) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean isSigned(int index) {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.SIGNED);
    }

    @Override
    public int getColumnDisplaySize(int index) {
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.DISPLAY_SIZE);
    }

    @Override
    public String getColumnLabel(int index) {
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.COLUMN_LABEL);
    }

    @Override
    public String getColumnName(int index) {
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.COLUMN);
    }

    @Override
    public String getSchemaName(int index) {
        int dotIndex;
        String name = this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.SCHEMA);
        if (name != null && (dotIndex = name.indexOf(46)) != -1) {
            return name.substring(0, dotIndex);
        }
        return null;
    }

    @Override
    public int getPrecision(int index) {
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.PRECISION);
    }

    @Override
    public int getScale(int index) {
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.SCALE);
    }

    @Override
    public String getTableName(int index) {
        int dotIndex;
        String name = this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.TABLE);
        if (name != null && (dotIndex = name.indexOf(46)) != -1) {
            return name.substring(dotIndex + 1);
        }
        return name;
    }

    @Override
    public String getCatalogName(int index) {
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.CATALOG);
    }

    @Override
    public int getColumnType(int index) {
        String runtimeTypeName = this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.DATA_TYPE);
        JcrType typeInfo = JcrType.typeInfo(runtimeTypeName);
        return typeInfo != null ? typeInfo.getJdbcType() : 12;
    }

    @Override
    public String getColumnTypeName(int index) {
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.DATA_TYPE);
    }

    @Override
    public boolean isReadOnly(int index) {
        return !this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    @Override
    public boolean isWritable(int index) {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    @Override
    public boolean isDefinitelyWritable(int index) {
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    @Override
    public String getColumnClassName(int index) {
        JcrType typeInfo = JcrType.typeInfo(this.getColumnTypeName(index));
        return typeInfo != null ? typeInfo.getRepresentationClass().getName() : String.class.getName();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLException(JdbcLocalI18n.classDoesNotImplementInterface.text(new Object[0]));
    }
}

