/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;

@ThreadSafe
public final class TimeBasedKeys {
    public static final short DEFAULT_BITS_IN_COUNTER = 16;
    private final short counterBits;
    private final long maximumCounterValue;
    private volatile long lastMillis;
    private volatile int counter;

    public static TimeBasedKeys create() {
        return new TimeBasedKeys(16);
    }

    public static TimeBasedKeys create(int bitsUsedInCounter) {
        CheckArg.isLessThanOrEqualTo(bitsUsedInCounter, 32, "bitsUsedInCounter");
        CheckArg.isPositive(bitsUsedInCounter, "bitsUsedInCounter");
        return new TimeBasedKeys((short)bitsUsedInCounter);
    }

    protected TimeBasedKeys(short bitsUsedInCounter) {
        this.counterBits = bitsUsedInCounter;
        this.maximumCounterValue = (1L << bitsUsedInCounter) - 1L;
    }

    public long nextKey() {
        long timestamp = System.currentTimeMillis();
        int increment = this.counterFor(timestamp);
        if ((long)increment <= this.maximumCounterValue) {
            return (timestamp << this.counterBits) + (long)increment;
        }
        return this.nextKey();
    }

    public long getCounterStartingAt(long millisInUtc) {
        return millisInUtc << this.counterBits;
    }

    public long getCounterEndingAt(long millisInUtc) {
        return (millisInUtc << this.counterBits) + this.maximumCounterValue;
    }

    public long getCounterEndingAfter(long millisInUtc) {
        return millisInUtc + 1L << this.counterBits;
    }

    public long getTimeGenerated(long key) {
        return key < this.maximumCounterValue ? 0L : key >> this.counterBits;
    }

    private synchronized int counterFor(long timestamp) {
        if (timestamp == this.lastMillis) {
            ++this.counter;
        } else {
            this.lastMillis = timestamp;
            this.counter = 0;
        }
        return this.counter;
    }
}

