/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.database;

import java.util.Objects;
import org.modeshape.common.util.CheckArg;

public class DatabaseType
implements Comparable<DatabaseType> {
    public static DatabaseType UNKNOWN = new DatabaseType(Name.UNKNOWN, 0, 0);
    private final int minorVersion;
    private final int majorVersion;
    private final Name name;

    public DatabaseType(Name name, int majorVersion, int minorVersion) {
        this.name = Objects.requireNonNull(name);
        CheckArg.isNonNegative(majorVersion, "majorVersion");
        this.minorVersion = minorVersion;
        CheckArg.isNonNegative(minorVersion, "minorVersion");
        this.majorVersion = majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public String nameString() {
        return this.name.name();
    }

    public Name name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseType that = (DatabaseType)o;
        return Objects.equals(this.minorVersion, that.minorVersion) && Objects.equals(this.majorVersion, that.majorVersion) && Objects.equals((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minorVersion, this.majorVersion, this.name});
    }

    @Override
    public int compareTo(DatabaseType other) {
        int nameComparison = this.name.compareTo(other.name);
        if (nameComparison != 0) {
            return nameComparison;
        }
        int majorVersionComparison = Integer.compare(this.majorVersion, other.majorVersion);
        if (majorVersionComparison != 0) {
            return majorVersionComparison;
        }
        int minorVersionComparison = Integer.compare(this.minorVersion, other.minorVersion);
        if (minorVersionComparison != 0) {
            return minorVersionComparison;
        }
        return 0;
    }

    public String toString() {
        return "Database[name=" + (Object)((Object)this.name) + ", majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + "]";
    }

    public static enum Name {
        MYSQL,
        POSTGRES,
        DERBY,
        HSQL,
        H2,
        SQLITE,
        DB2,
        DB2_390,
        INFORMIX,
        INTERBASE,
        FIREBIRD,
        SQLSERVER,
        ACCESS,
        ORACLE,
        SYBASE,
        CASSANDRA,
        UNKNOWN;

    }
}

