/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.database;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;
import org.modeshape.common.database.DatabaseType;

public class DatabaseUtil {
    private DatabaseUtil() {
    }

    public static DatabaseType determineType(DatabaseMetaData metaData) throws SQLException {
        metaData = Objects.requireNonNull(metaData, "metaData cannot be null");
        int majorVersion = metaData.getDatabaseMajorVersion();
        int minorVersion = metaData.getDatabaseMinorVersion();
        String name = metaData.getDatabaseProductName().toLowerCase();
        if (name.contains("mysql")) {
            return new DatabaseType(DatabaseType.Name.MYSQL, majorVersion, minorVersion);
        }
        if (name.contains("postgres")) {
            return new DatabaseType(DatabaseType.Name.POSTGRES, majorVersion, minorVersion);
        }
        if (name.contains("derby")) {
            return new DatabaseType(DatabaseType.Name.DERBY, majorVersion, minorVersion);
        }
        if (name.contains("hsql") || name.toLowerCase().contains("hypersonic")) {
            return new DatabaseType(DatabaseType.Name.HSQL, majorVersion, minorVersion);
        }
        if (name.contains("h2")) {
            return new DatabaseType(DatabaseType.Name.H2, majorVersion, minorVersion);
        }
        if (name.contains("sqlite")) {
            return new DatabaseType(DatabaseType.Name.SQLITE, majorVersion, minorVersion);
        }
        if (name.contains("db2")) {
            return new DatabaseType(DatabaseType.Name.DB2, majorVersion, minorVersion);
        }
        if (name.contains("informix")) {
            return new DatabaseType(DatabaseType.Name.INFORMIX, majorVersion, minorVersion);
        }
        if (name.contains("interbase")) {
            return new DatabaseType(DatabaseType.Name.INTERBASE, majorVersion, minorVersion);
        }
        if (name.contains("firebird")) {
            return new DatabaseType(DatabaseType.Name.FIREBIRD, majorVersion, minorVersion);
        }
        if (name.contains("sqlserver") || name.toLowerCase().contains("microsoft")) {
            return new DatabaseType(DatabaseType.Name.SQLSERVER, majorVersion, minorVersion);
        }
        if (name.contains("access")) {
            return new DatabaseType(DatabaseType.Name.ACCESS, majorVersion, minorVersion);
        }
        if (name.contains("oracle")) {
            return new DatabaseType(DatabaseType.Name.ORACLE, majorVersion, minorVersion);
        }
        if (name.contains("adaptive")) {
            return new DatabaseType(DatabaseType.Name.SYBASE, majorVersion, minorVersion);
        }
        if (name.contains("cassandra")) {
            return new DatabaseType(DatabaseType.Name.CASSANDRA, majorVersion, minorVersion);
        }
        return DatabaseType.UNKNOWN;
    }
}

