/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.clustering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.modeshape.clustering.ClusteredObservationBus;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CreateNodeRequest;

public class ClusteredObservationBusTest {
    private ClusteredObservationBus bus;
    private ExecutionContext context = new ExecutionContext();
    protected JChannel mockChannel;

    @Before
    public void beforeEach() {
        this.mockChannel = (JChannel)Mockito.mock(JChannel.class);
        this.bus = this.newBus(this.mockChannel);
    }

    @Test
    public void shouldSerializeAndDeserializeChanges() throws Exception {
        Changes changes = this.changes();
        byte[] data = ClusteredObservationBus.serialize((Changes)changes);
        Changes deserialized = ClusteredObservationBus.deserialize((byte[])data);
        Assert.assertThat((Object)changes, Is.is(deserialized));
        Assert.assertThat((Object)changes, Is.is(IsNot.not(IsSame.sameInstance(deserialized))));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowSettingClusterNameToNull() {
        this.bus.setClusterName(null);
    }

    @Test
    public void shouldAllowSettingClusterNameToBlankString() {
        this.setAndGetClusterName("");
    }

    @Test
    public void shouldAllowSettingClusterNameToStringWithAlphaNumericCharacters() {
        this.setAndGetClusterName("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    @Test
    public void shouldAllowSettingClusterNameToStringWithAlphaNumericAndPunctuationCharacters() {
        this.setAndGetClusterName("valid.cluster!name@#$%^&*()<>?,./:\"'[]\\{}|_+-=");
    }

    @Test
    public void shouldAllowSettingClusterNameToStringWithAlphaNumericAndWhitespaceCharacters() {
        this.setAndGetClusterName("valid cluster name");
    }

    @Test
    public void shouldAllowSettingConfigurationToNull() {
        this.setAndGetConfiguration(null);
    }

    @Test
    public void shouldAllowSettingConfigurationToBlankString() {
        this.setAndGetConfiguration(null);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowStartingWithoutSettingClusterName() {
        Assert.assertThat((Object)this.bus.getClusterName(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.start();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(true));
        this.bus.shutdown();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
    }

    @Test
    public void shouldAllowStartingWithoutSettingConfiguration() {
        this.bus.setClusterName("clusterName");
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.start();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(true));
        this.bus.shutdown();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
    }

    @Test
    public void shouldAllowShuttingDownWithoutHavingStarted() {
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.shutdown();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotAllowSettingConfigurationAfterBusHasBeenStartedButBeforeBusHasBeenShutdown() {
        this.bus.setClusterName("clusterName");
        this.bus.setConfiguration("old configuration");
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.start();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(true));
        this.bus.setConfiguration("new configuration");
    }

    @Test
    public void shouldAllowSettingConfigurationAfterBusHasBeenStartedAndShutdown() {
        this.bus.setClusterName("clusterName");
        this.bus.setConfiguration("old configuration");
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.start();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(true));
        this.bus.shutdown();
        Assert.assertThat((Object)this.bus.isStarted(), Is.is(false));
        this.bus.setConfiguration("new configuration");
    }

    @Test
    public void shouldAllowNotifyToBeCalledBeforeStartButShouldDoNothing() throws Exception {
        this.bus.setClusterName("clusterName");
        this.bus.notify(this.changes());
        ArgumentCaptor argument = ArgumentCaptor.forClass(Message.class);
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.never())).send((Message)argument.capture());
    }

    @Test
    public void shouldAllowNotifyToBeCalledAfterStartWithMultipleMembersAndShouldSendMessageToJGroups() throws Exception {
        this.bus.setClusterName("clusterName");
        this.bus.start();
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).addChannelListener((ChannelListener)ArgumentCaptor.forClass(ChannelListener.class).capture());
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).connect("clusterName");
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).setReceiver((Receiver)ArgumentCaptor.forClass(Receiver.class).capture());
        this.bus.isOpen.set(true);
        this.bus.multipleAddressesInCluster.set(true);
        this.bus.notify(this.changes());
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).send((Message)ArgumentCaptor.forClass(Message.class).capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockChannel});
    }

    @Test
    public void shouldAllowNotifyToBeCalledAfterStartWithOneMemberAndShouldSendMessageToLocalObserversBuNotJGroups() throws Exception {
        this.bus.setClusterName("clusterName");
        this.bus.start();
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).addChannelListener((ChannelListener)ArgumentCaptor.forClass(ChannelListener.class).capture());
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).connect("clusterName");
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.times((int)1))).setReceiver((Receiver)ArgumentCaptor.forClass(Receiver.class).capture());
        this.bus.isOpen.set(true);
        this.bus.multipleAddressesInCluster.set(false);
        Observer observer = (Observer)Mockito.mock(Observer.class);
        this.bus.register(observer);
        Changes changes = this.changes();
        this.bus.notify(changes);
        ((JChannel)Mockito.verify((Object)this.mockChannel, (VerificationMode)Mockito.never())).send((Message)ArgumentCaptor.forClass(Message.class).capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockChannel});
        ((Observer)Mockito.verify((Object)observer, (VerificationMode)Mockito.times((int)1))).notify(changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldProperlySendChangesThroughRealJGroupsCluster() throws Exception {
        CountDownLatch latch = new CountDownLatch(3);
        CustomObserver observer1 = new CustomObserver(latch);
        CustomObserver observer2 = new CustomObserver(latch);
        CustomObserver observer3 = new CustomObserver(latch);
        String name = "MyCluster";
        ClusteredObservationBus bus1 = this.startNewBus(name, observer1);
        try {
            ClusteredObservationBus bus2 = this.startNewBus(name, observer2);
            try {
                ClusteredObservationBus bus3 = this.startNewBus(name, observer3);
                try {
                    Changes changes = this.changes();
                    bus1.notify(changes);
                    observer1.await();
                    observer2.await();
                    observer3.await();
                    Assert.assertThat((Object)observer1.getObservedChanges().size(), Is.is(1));
                    Assert.assertThat((Object)observer2.getObservedChanges().size(), Is.is(1));
                    Assert.assertThat((Object)observer3.getObservedChanges().size(), Is.is(1));
                    Assert.assertThat((Object)observer1.getObservedChanges().get(0), Is.is(changes));
                    Assert.assertThat((Object)observer2.getObservedChanges().get(0), Is.is(changes));
                    Assert.assertThat((Object)observer3.getObservedChanges().get(0), Is.is(changes));
                }
                finally {
                    bus3.shutdown();
                }
            }
            finally {
                bus2.shutdown();
            }
        }
        finally {
            bus1.shutdown();
        }
    }

    protected void setAndGetClusterName(String name) {
        this.bus.setClusterName(name);
        String nameAfter = this.bus.getClusterName();
        Assert.assertThat((Object)nameAfter, Is.is(name));
    }

    protected void setAndGetConfiguration(String config) {
        this.bus.setConfiguration(config);
        String configAfter = this.bus.getConfiguration();
        Assert.assertThat((Object)configAfter, Is.is(config));
    }

    protected ClusteredObservationBus startNewBus(String name, Observer localObserver) {
        ClusteredObservationBus bus = this.newBus(null);
        bus.setClusterName(name);
        bus.start();
        bus.register(localObserver);
        return bus;
    }

    protected ClusteredObservationBus newBus(final JChannel channel) {
        return channel == null ? new ClusteredObservationBus() : new ClusteredObservationBus(){

            protected JChannel newChannel(String configuration) {
                return channel;
            }
        };
    }

    protected Changes changes() {
        DateTime now = this.context.getValueFactories().getDateFactory().create();
        Path path = (Path)this.context.getValueFactories().getPathFactory().create("/a");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create("b");
        Path childPath = this.context.getValueFactories().getPathFactory().create(path, new Name[]{childName});
        CreateNodeRequest request = new CreateNodeRequest(Location.create((Path)path), "workspaceName", childName, new Property[0]);
        request.setActualLocationOfNode(Location.create((Path)childPath));
        List<CreateNodeRequest> requests = Collections.singletonList(request);
        return new Changes("processId", "contextId", "username", "sourceName", now, requests, null);
    }

    protected static class CustomObserver
    implements Observer {
        private final List<Changes> receivedChanges = new ArrayList<Changes>();
        private final CountDownLatch latch;

        protected CustomObserver(CountDownLatch latch) {
            this.latch = latch;
        }

        public void notify(Changes changes) {
            this.receivedChanges.add(changes);
            this.latch.countDown();
        }

        public void await() throws InterruptedException {
            this.latch.await(250L, TimeUnit.MILLISECONDS);
        }

        public List<Changes> getObservedChanges() {
            return this.receivedChanges;
        }
    }
}

