/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import org.jgroups.Channel;
import org.jgroups.TimeoutException;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class RpcDispatcherUnicastMethodExceptionTest
extends ChannelTestBase {
    RpcDispatcher disp;
    Channel channel;

    @BeforeClass
    protected void setUp() throws Exception {
        this.channel = this.createChannel(true);
        this.disp = new RpcDispatcher(this.channel, null, null, this);
        this.channel.connect(RpcDispatcherUnicastMethodExceptionTest.getUniqueClusterName("RpcDispatcherUnicastMethodExceptionTest"));
    }

    @AfterClass
    protected void tearDown() throws Exception {
        this.disp.stop();
        this.channel.close();
    }

    @Test(enabled=false)
    public static Object foo() {
        return "foo(): OK";
    }

    @Test(enabled=false)
    public static Object bar() throws Exception {
        throw new TimeoutException("this is an exception");
    }

    @Test(enabled=false)
    public static Object foobar() {
        throw new IllegalArgumentException("bla bla bla from foobar");
    }

    @Test(enabled=false)
    public static Object foofoobar() {
        throw new AssertionError((Object)"bla bla bla from foofoobar");
    }

    @Test(enabled=false)
    public static void fooWithThrowable() throws Throwable {
        throw new Throwable("this is an exception");
    }

    public void testMethodWithoutException() throws Throwable {
        Object retval = this.disp.callRemoteMethod(this.channel.getAddress(), "foo", null, (Class[])null, 2, 5000L);
        System.out.println("retval: " + retval);
        RpcDispatcherUnicastMethodExceptionTest.assertNotNull(retval);
    }

    @Test(expectedExceptions={TimeoutException.class})
    public void testMethodWithException() throws Throwable {
        Object retval = this.disp.callRemoteMethod(this.channel.getAddress(), "bar", null, (Class[])null, 2, 5000L);
        System.out.println("retval: " + retval);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMethodWithException2() throws Throwable {
        Object retval = this.disp.callRemoteMethod(this.channel.getAddress(), "foobar", null, (Class[])null, 2, 5000L);
        System.out.println("retval: " + retval);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testMethodWithError() throws Throwable {
        Object retval = this.disp.callRemoteMethod(this.channel.getAddress(), "foofoobar", null, (Class[])null, 2, 5000L);
        System.out.println("retval: " + retval);
    }

    @Test(expectedExceptions={Throwable.class})
    public void testMethodWithThrowable() throws Throwable {
        Object retval = this.disp.callRemoteMethod(this.channel.getAddress(), "fooWithThrowable", null, (Class[])null, 2, 5000L);
        System.out.println("retval: " + retval);
    }
}

