/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.clustering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.clustering.ClusteredObservationBus;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CreateNodeRequest;

public class ClusteredObservationBusIntegerationTest {
    private ExecutionContext context = new ExecutionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldProperlySendChangesThroughRealJGroupsCluster() throws Exception {
        Changes changes;
        CustomObserver observer1 = new CustomObserver();
        CustomObserver observer2 = new CustomObserver();
        CustomObserver observer3 = new CustomObserver();
        String name = "MyCluster";
        ClusteredObservationBus bus1 = this.startNewBus(name, observer1);
        try {
            observer1.expectChanges(1);
            observer2.expectChanges(0);
            observer3.expectChanges(0);
            changes = this.changes();
            bus1.notify(changes);
            observer1.await();
            observer2.await();
            observer3.await();
            Assert.assertThat((Object)observer1.getObservedChanges().size(), (Matcher)Is.is((Object)1));
            Assert.assertThat((Object)observer2.getObservedChanges().size(), (Matcher)Is.is((Object)0));
            Assert.assertThat((Object)observer3.getObservedChanges().size(), (Matcher)Is.is((Object)0));
            Assert.assertThat((Object)observer1.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
            ClusteredObservationBus bus2 = this.startNewBus(name, observer2);
            try {
                observer1.expectChanges(1);
                observer2.expectChanges(1);
                observer3.expectChanges(0);
                changes = this.changes();
                bus1.notify(changes);
                observer1.await();
                observer2.await();
                observer3.await();
                Assert.assertThat((Object)observer1.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                Assert.assertThat((Object)observer2.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                Assert.assertThat((Object)observer3.getObservedChanges().size(), (Matcher)Is.is((Object)0));
                Assert.assertThat((Object)observer1.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                Assert.assertThat((Object)observer2.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                observer1.expectChanges(1);
                observer2.expectChanges(1);
                observer3.expectChanges(0);
                changes = this.changes();
                bus2.notify(changes);
                observer1.await();
                observer2.await();
                observer3.await();
                Assert.assertThat((Object)observer1.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                Assert.assertThat((Object)observer2.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                Assert.assertThat((Object)observer3.getObservedChanges().size(), (Matcher)Is.is((Object)0));
                Assert.assertThat((Object)observer1.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                Assert.assertThat((Object)observer2.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                ClusteredObservationBus bus3 = this.startNewBus(name, observer3);
                try {
                    observer1.expectChanges(1);
                    observer2.expectChanges(1);
                    observer3.expectChanges(1);
                    changes = this.changes();
                    bus1.notify(changes);
                    observer1.await();
                    observer2.await();
                    observer3.await();
                    Assert.assertThat((Object)observer1.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer2.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer3.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer1.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                    Assert.assertThat((Object)observer2.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                    Assert.assertThat((Object)observer3.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                    observer1.expectChanges(1);
                    observer2.expectChanges(1);
                    observer3.expectChanges(1);
                    Changes changes2 = this.changes();
                    bus2.notify(changes2);
                    observer1.await();
                    observer2.await();
                    observer3.await();
                    Assert.assertThat((Object)observer1.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer2.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer3.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer1.getObservedChanges().get(0), (Matcher)Is.is((Object)changes2));
                    Assert.assertThat((Object)observer2.getObservedChanges().get(0), (Matcher)Is.is((Object)changes2));
                    Assert.assertThat((Object)observer3.getObservedChanges().get(0), (Matcher)Is.is((Object)changes2));
                    observer1.expectChanges(1);
                    observer2.expectChanges(1);
                    observer3.expectChanges(1);
                    Changes changes3 = this.changes();
                    bus3.notify(changes3);
                    observer1.await();
                    observer2.await();
                    observer3.await();
                    Assert.assertThat((Object)observer1.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer2.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer3.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                    Assert.assertThat((Object)observer1.getObservedChanges().get(0), (Matcher)Is.is((Object)changes3));
                    Assert.assertThat((Object)observer2.getObservedChanges().get(0), (Matcher)Is.is((Object)changes3));
                    Assert.assertThat((Object)observer3.getObservedChanges().get(0), (Matcher)Is.is((Object)changes3));
                }
                finally {
                    bus3.shutdown();
                }
            }
            finally {
                observer1.expectChanges(1);
                observer2.expectChanges(1);
                observer3.expectChanges(0);
                changes = this.changes();
                bus2.notify(changes);
                observer1.await();
                observer2.await();
                observer3.await();
                Assert.assertThat((Object)observer1.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                Assert.assertThat((Object)observer2.getObservedChanges().size(), (Matcher)Is.is((Object)1));
                Assert.assertThat((Object)observer3.getObservedChanges().size(), (Matcher)Is.is((Object)0));
                Assert.assertThat((Object)observer1.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                Assert.assertThat((Object)observer2.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
                bus2.shutdown();
            }
        }
        finally {
            observer1.expectChanges(1);
            observer2.expectChanges(0);
            observer3.expectChanges(0);
            changes = this.changes();
            bus1.notify(changes);
            observer1.await();
            observer2.await();
            observer3.await();
            Assert.assertThat((Object)observer1.getObservedChanges().size(), (Matcher)Is.is((Object)1));
            Assert.assertThat((Object)observer2.getObservedChanges().size(), (Matcher)Is.is((Object)0));
            Assert.assertThat((Object)observer3.getObservedChanges().size(), (Matcher)Is.is((Object)0));
            Assert.assertThat((Object)observer1.getObservedChanges().get(0), (Matcher)Is.is((Object)changes));
            bus1.shutdown();
        }
    }

    protected ClusteredObservationBus startNewBus(String name, Observer localObserver) {
        ClusteredObservationBus bus = new ClusteredObservationBus();
        bus.setClusterName(name);
        bus.start();
        bus.register(localObserver);
        return bus;
    }

    protected Changes changes() {
        DateTime now = this.context.getValueFactories().getDateFactory().create();
        Path path = (Path)this.context.getValueFactories().getPathFactory().create("/a");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create("b");
        Path childPath = this.context.getValueFactories().getPathFactory().create(path, new Name[]{childName});
        CreateNodeRequest request = new CreateNodeRequest(Location.create((Path)path), "workspaceName", childName, new Property[0]);
        request.setActualLocationOfNode(Location.create((Path)childPath));
        List<CreateNodeRequest> requests = Collections.singletonList(request);
        return new Changes("processId", "contextId", "username", "sourceName", now, requests, null);
    }

    protected static class CustomObserver
    implements Observer {
        private final List<Changes> receivedChanges = new ArrayList<Changes>();
        private CountDownLatch latch;

        protected CustomObserver() {
        }

        public void expectChanges(int expectedNumberOfChanges) {
            this.latch = new CountDownLatch(expectedNumberOfChanges);
            this.receivedChanges.clear();
        }

        public void notify(Changes changes) {
            this.receivedChanges.add(changes);
            this.latch.countDown();
        }

        public void await() throws InterruptedException {
            this.latch.await(250L, TimeUnit.MILLISECONDS);
        }

        public List<Changes> getObservedChanges() {
            return this.receivedChanges;
        }
    }
}

