/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class LargeStateServer {
    ServerSocket srv_sock;
    InetAddress bind_addr;

    private void start(String bind_addr, int chunk_size) throws Exception {
        this.bind_addr = InetAddress.getByName(bind_addr);
        this.srv_sock = new ServerSocket(7500, 50, this.bind_addr);
        while (true) {
            System.out.println("-- waiting for clients to connect");
            Socket sock = this.srv_sock.accept();
            sock.setSendBufferSize(chunk_size);
            this.sendLargeState(sock);
            sock.close();
        }
    }

    private void sendLargeState(Socket sock) throws IOException {
        long total = 0L;
        OutputStream out = sock.getOutputStream();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            byte[] buf = new byte[1000];
            out.write(buf, 0, buf.length);
            if ((total += 1000L) % 100000000L != 0L) continue;
            System.out.println("-- sent " + total / 1000000L + " MB");
        }
        long stop = System.currentTimeMillis();
        out.close();
        System.out.println("- done, wrote " + total / 1000000L + " MB in " + (stop - start) + "ms (" + (double)(total / 1000000L) / ((double)(stop - start) / 1000.0) + " MB/sec");
    }

    public static void main(String[] args) throws Exception {
        String bind_addr = null;
        int chunk = 10000;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bind_addr")) {
                bind_addr = args[++i];
                continue;
            }
            if (args[i].equals("-chunk")) {
                chunk = Integer.parseInt(args[++i]);
                continue;
            }
            System.out.println("LargeStateServer [-bind_addr <addr>] [-chunk <size in bytes>]");
            return;
        }
        new LargeStateServer().start(bind_addr, chunk);
    }
}

