/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.math;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Duration
extends Number
implements Comparable<Duration> {
    private static final long serialVersionUID = 1L;
    private final long durationInNanos;
    private Components components;

    public Duration(long nanos) {
        this(nanos, TimeUnit.NANOSECONDS);
    }

    public Duration(long duration, TimeUnit unit) {
        this.durationInNanos = TimeUnit.NANOSECONDS.convert(duration, unit);
    }

    @Override
    public double doubleValue() {
        return this.durationInNanos;
    }

    @Override
    public float floatValue() {
        return this.durationInNanos;
    }

    @Override
    public int intValue() {
        return (int)this.durationInNanos;
    }

    @Override
    public long longValue() {
        return this.durationInNanos;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.durationInNanos);
    }

    public Duration add(long duration, TimeUnit unit) {
        long durationInNanos = TimeUnit.NANOSECONDS.convert(duration, unit);
        return new Duration(this.durationInNanos + durationInNanos);
    }

    public Duration subtract(long duration, TimeUnit unit) {
        long durationInNanos = TimeUnit.NANOSECONDS.convert(duration, unit);
        return new Duration(this.durationInNanos - durationInNanos);
    }

    public Duration add(Duration duration) {
        return new Duration(this.durationInNanos + (duration == null ? 0L : duration.longValue()));
    }

    public Duration subtract(Duration duration) {
        return new Duration(this.durationInNanos - (duration == null ? 0L : duration.longValue()));
    }

    public Duration multiply(long scale) {
        return new Duration(this.durationInNanos * scale);
    }

    public Duration divide(long denominator) {
        return new Duration(this.durationInNanos / denominator);
    }

    public double divide(Duration duration) {
        return this.toBigDecimal().divide(duration.toBigDecimal()).doubleValue();
    }

    @Override
    public int compareTo(Duration that) {
        if (that == null) {
            return 1;
        }
        return this.durationInNanos < that.durationInNanos ? -1 : (this.durationInNanos > that.durationInNanos ? 1 : 0);
    }

    public long getDuratinInNanoseconds() {
        return this.durationInNanos;
    }

    public BigDecimal getDurationInMicroseconds() {
        return this.toBigDecimal().divide(new BigDecimal(1000));
    }

    public BigDecimal getDurationInMilliseconds() {
        return this.toBigDecimal().divide(new BigDecimal(1000000));
    }

    public BigDecimal getDurationInSeconds() {
        return this.toBigDecimal().divide(new BigDecimal(1000000000));
    }

    public Components getComponents() {
        if (this.components == null) {
            BigDecimal bigSeconds = new BigDecimal(this.durationInNanos).divide(new BigDecimal(1000000000));
            int minutes = bigSeconds.intValue() / 60;
            double dMinutes = minutes;
            double seconds = bigSeconds.doubleValue() - dMinutes * 60.0;
            int hours = minutes / 60;
            this.components = new Components(hours, minutes -= hours * 60, seconds);
        }
        return this.components;
    }

    public long getDuration(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        return unit.convert(this.durationInNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return this.getComponents().toString().replaceAll("(\\d{2}).(\\d{3})(\\d{1,3})", "$1.$2,$3");
    }

    public class Components {
        private final int hours;
        private final int minutes;
        private final double seconds;

        protected Components(int hours, int minutes, double seconds) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }

        public int getHours() {
            return this.hours;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public double getSeconds() {
            return this.seconds;
        }

        public String toString() {
            String result = new DecimalFormat("######00").format(this.hours) + ':' + new DecimalFormat("00").format(this.minutes) + ':' + new DecimalFormat("00.000###").format(this.seconds);
            return result;
        }
    }
}

