/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.xml.XmlCharacters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class TokenStream {
    public static final String ANY_VALUE = "any value";
    public static final int ANY_TYPE = Integer.MIN_VALUE;
    protected final String inputString;
    protected final String inputUppercased;
    private final char[] inputContent;
    private final boolean caseSensitive;
    private final Tokenizer tokenizer;
    private List<Token> tokens;
    private ListIterator<Token> tokenIterator;
    private Token currentToken;
    private boolean completed;

    public TokenStream(String content, Tokenizer tokenizer, boolean caseSensitive) {
        CheckArg.isNotNull(content, "content");
        CheckArg.isNotNull(tokenizer, "tokenizer");
        this.inputString = content;
        this.inputContent = content.toCharArray();
        this.caseSensitive = caseSensitive;
        this.inputUppercased = caseSensitive ? this.inputString : content.toUpperCase();
        this.tokenizer = tokenizer;
    }

    public TokenStream start() throws ParsingException {
        if (this.tokens == null) {
            TokenFactory tokenFactory = this.caseSensitive ? new CaseSensitiveTokenFactory() : new CaseInsensitiveTokenFactory();
            CharacterArrayStream characterStream = new CharacterArrayStream(this.inputContent);
            this.tokenizer.tokenize(characterStream, tokenFactory);
            this.tokens = this.initializeTokens(tokenFactory.getTokens());
        }
        this.tokenIterator = this.tokens.listIterator();
        this.moveToNextToken();
        return this;
    }

    protected List<Token> initializeTokens(List<Token> tokens) {
        return tokens;
    }

    public void rewind() {
        this.tokenIterator = this.tokens.listIterator();
        this.completed = false;
        this.currentToken = null;
        this.moveToNextToken();
    }

    public Position previousPosition() {
        return this.previousToken().position();
    }

    public Position nextPosition() {
        return this.currentToken().position();
    }

    public int consumeInteger() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value();
        try {
            int result = Integer.parseInt(value);
            this.moveToNextToken();
            return result;
        }
        catch (NumberFormatException e) {
            Position position = this.currentToken().position();
            String msg = CommonI18n.expectingValidIntegerAtLineAndColumn.text(value, position.getLine(), position.getColumn());
            throw new ParsingException(position, msg);
        }
    }

    public long consumeLong() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value();
        try {
            long result = Long.parseLong(value);
            this.moveToNextToken();
            return result;
        }
        catch (NumberFormatException e) {
            Position position = this.currentToken().position();
            String msg = CommonI18n.expectingValidLongAtLineAndColumn.text(value, position.getLine(), position.getColumn());
            throw new ParsingException(position, msg);
        }
    }

    public boolean consumeBoolean() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String value = this.currentToken().value();
        try {
            boolean result = Boolean.parseBoolean(value);
            this.moveToNextToken();
            return result;
        }
        catch (NumberFormatException e) {
            Position position = this.currentToken().position();
            String msg = CommonI18n.expectingValidBooleanAtLineAndColumn.text(value, position.getLine(), position.getColumn());
            throw new ParsingException(position, msg);
        }
    }

    public String consume() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String result = this.currentToken().value();
        this.moveToNextToken();
        return result;
    }

    protected void throwNoMoreContent() throws ParsingException {
        String msg = CommonI18n.noMoreContent.text(new Object[0]);
        Position pos = this.tokens.isEmpty() ? new Position(-1, 1, 0) : this.tokens.get(this.tokens.size() - 1).position();
        throw new ParsingException(pos, msg);
    }

    public void consume(String expected) throws ParsingException, IllegalStateException {
        if (this.completed) {
            String msg = CommonI18n.noMoreContentButWasExpectingToken.text(expected);
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), msg);
        }
        if (expected != ANY_VALUE && !this.currentToken().matches(expected)) {
            String found = this.currentToken().value();
            Position pos = this.currentToken().position();
            String fragment = this.generateFragment();
            String msg = CommonI18n.unexpectedToken.text(expected, found, pos.getLine(), pos.getColumn(), fragment);
            throw new ParsingException(pos, msg);
        }
        this.moveToNextToken();
    }

    public void consume(char expected) throws ParsingException, IllegalStateException {
        if (this.completed) {
            String msg = CommonI18n.noMoreContentButWasExpectingCharacter.text(Character.valueOf(expected));
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), msg);
        }
        if (!this.currentToken().matches(expected)) {
            String found = this.currentToken().value();
            Position pos = this.currentToken().position();
            String fragment = this.generateFragment();
            String msg = CommonI18n.unexpectedCharacter.text(Character.valueOf(expected), found, pos.getLine(), pos.getColumn(), fragment);
            throw new ParsingException(pos, msg);
        }
        this.moveToNextToken();
    }

    public void consume(int expectedType) throws ParsingException, IllegalStateException {
        if (this.completed) {
            String msg = CommonI18n.noMoreContentButWasExpectingTokenType.text(expectedType);
            throw new ParsingException(this.tokens.get(this.tokens.size() - 1).position(), msg);
        }
        if (expectedType != Integer.MIN_VALUE && this.currentToken().type() != expectedType) {
            String found = this.currentToken().value();
            Position pos = this.currentToken().position();
            String fragment = this.generateFragment();
            String msg = CommonI18n.unexpectedTokenType.text(expectedType, found, pos.getLine(), pos.getColumn(), fragment);
            throw new ParsingException(pos, msg);
        }
        this.moveToNextToken();
    }

    public void consume(String expected, String ... expectedForNextTokens) throws ParsingException, IllegalStateException {
        this.consume(expected);
        for (String nextExpected : expectedForNextTokens) {
            this.consume(nextExpected);
        }
    }

    public void consume(String[] nextTokens) throws ParsingException, IllegalStateException {
        for (String nextExpected : nextTokens) {
            this.consume(nextExpected);
        }
    }

    public void consume(Iterable<String> nextTokens) throws ParsingException, IllegalStateException {
        for (String nextExpected : nextTokens) {
            this.consume(nextExpected);
        }
    }

    public boolean canConsume(String expected) throws IllegalStateException {
        if (!this.matches(expected)) {
            return false;
        }
        this.moveToNextToken();
        return true;
    }

    public boolean canConsume(char expected) throws IllegalStateException {
        if (!this.matches(expected)) {
            return false;
        }
        this.moveToNextToken();
        return true;
    }

    public boolean canConsume(int expectedType) throws IllegalStateException {
        if (!this.matches(expectedType)) {
            return false;
        }
        this.moveToNextToken();
        return true;
    }

    public boolean canConsume(String currentExpected, String ... expectedForNextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        if (!iter.hasNext()) {
            return false;
        }
        Token token = iter.next();
        if (currentExpected != ANY_VALUE && !token.matches(currentExpected)) {
            return false;
        }
        for (String nextExpected : expectedForNextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        this.tokenIterator = iter;
        this.currentToken = this.tokenIterator.hasNext() ? this.tokenIterator.next() : null;
        this.completed = this.currentToken == null;
        return true;
    }

    public boolean canConsume(String[] nextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (String nextExpected : nextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        this.tokenIterator = iter;
        this.currentToken = this.tokenIterator.hasNext() ? this.tokenIterator.next() : null;
        this.completed = this.currentToken == null;
        return true;
    }

    public boolean canConsume(Iterable<String> nextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (String nextExpected : nextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        this.tokenIterator = iter;
        this.currentToken = this.tokenIterator.hasNext() ? this.tokenIterator.next() : null;
        this.completed = this.currentToken == null;
        return true;
    }

    public boolean canConsumeAnyOf(String firstOption, String ... additionalOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        if (this.canConsume(firstOption)) {
            return true;
        }
        for (String nextOption : additionalOptions) {
            if (!this.canConsume(nextOption)) continue;
            return true;
        }
        return false;
    }

    public boolean canConsumeAnyOf(String[] options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        for (String option : options) {
            if (!this.canConsume(option)) continue;
            return true;
        }
        return false;
    }

    public boolean canConsumeAnyOf(Iterable<String> options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        for (String option : options) {
            if (!this.canConsume(option)) continue;
            return true;
        }
        return false;
    }

    public boolean canConsumeAnyOf(int firstTypeOption, int ... additionalTypeOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        if (this.canConsume(firstTypeOption)) {
            return true;
        }
        for (int nextTypeOption : additionalTypeOptions) {
            if (!this.canConsume(nextTypeOption)) continue;
            return true;
        }
        return false;
    }

    public boolean canConsumeAnyOf(int[] typeOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        for (int nextTypeOption : typeOptions) {
            if (!this.canConsume(nextTypeOption)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String expected) throws IllegalStateException {
        return !this.completed && (expected == ANY_VALUE || this.currentToken().matches(expected));
    }

    public boolean matches(char expected) throws IllegalStateException {
        return !this.completed && this.currentToken().matches(expected);
    }

    public boolean matches(int expectedType) throws IllegalStateException {
        return !this.completed && this.currentToken().matches(expectedType);
    }

    public boolean matches(String currentExpected, String ... expectedForNextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        if (!iter.hasNext()) {
            return false;
        }
        Token token = iter.next();
        if (currentExpected != ANY_VALUE && !token.matches(currentExpected)) {
            return false;
        }
        for (String nextExpected : expectedForNextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(String[] nextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (String nextExpected : nextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Iterable<String> nextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (String nextExpected : nextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpected == ANY_VALUE || token.matches(nextExpected)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(int currentExpectedType, int ... expectedTypeForNextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        if (!iter.hasNext()) {
            return false;
        }
        Token token = iter.next();
        if (currentExpectedType != Integer.MIN_VALUE && this.currentToken().type() != currentExpectedType) {
            return false;
        }
        for (int nextExpectedType : expectedTypeForNextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpectedType == Integer.MIN_VALUE || token.type() == nextExpectedType) continue;
            return false;
        }
        return true;
    }

    public boolean matches(int[] typesForNextTokens) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        Token token = null;
        for (int nextExpectedType : typesForNextTokens) {
            if (!iter.hasNext()) {
                return false;
            }
            token = iter.next();
            if (nextExpectedType == Integer.MIN_VALUE || token.matches(nextExpectedType)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesAnyOf(String firstOption, String ... additionalOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        if (current.matches(firstOption)) {
            return true;
        }
        for (String nextOption : additionalOptions) {
            if (!current.matches(nextOption)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyOf(String[] options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        for (String option : options) {
            if (!current.matches(option)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyOf(Iterable<String> options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        for (String option : options) {
            if (!current.matches(option)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyOf(int firstTypeOption, int ... additionalTypeOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        int currentType = this.currentToken().type();
        if (currentType == firstTypeOption) {
            return true;
        }
        for (int nextTypeOption : additionalTypeOptions) {
            if (currentType != nextTypeOption) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyOf(int[] typeOptions) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        int currentType = this.currentToken().type();
        for (int nextTypeOption : typeOptions) {
            if (currentType != nextTypeOption) continue;
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        if (this.tokenIterator == null) {
            throw new IllegalStateException(CommonI18n.startMethodMustBeCalledBeforeNext.text(new Object[0]));
        }
        return !this.completed;
    }

    public String toString() {
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        StringBuilder sb = new StringBuilder();
        if (iter.hasNext()) {
            sb.append(iter.next());
            int count = 1;
            while (iter.hasNext()) {
                if (count > 20) {
                    sb.append(" ...");
                    break;
                }
                sb.append("  ");
                ++count;
                sb.append(iter.next());
            }
        }
        return sb.toString();
    }

    private void moveToNextToken() {
        if (!this.tokenIterator.hasNext()) {
            this.completed = true;
            this.currentToken = null;
        } else {
            this.currentToken = this.tokenIterator.next();
        }
    }

    final Token currentToken() throws IllegalStateException, NoSuchElementException {
        if (this.currentToken == null) {
            if (this.completed) {
                throw new NoSuchElementException(CommonI18n.noMoreContent.text(new Object[0]));
            }
            throw new IllegalStateException(CommonI18n.startMethodMustBeCalledBeforeConsumingOrMatching.text(new Object[0]));
        }
        assert (this.currentToken != null);
        return this.currentToken;
    }

    public String getContentBetween(Position starting, Position end) {
        CheckArg.isNotNull(starting, "starting");
        int startIndex = starting.getIndexInContent();
        int endIndex = this.inputString.length();
        if (end != null) {
            endIndex = end.getIndexInContent();
        }
        if (startIndex >= endIndex) {
            throw new IllegalArgumentException(CommonI18n.endPositionMustBeGreaterThanStartingPosition.text(startIndex, endIndex));
        }
        return this.inputString.substring(startIndex, endIndex);
    }

    final Token previousToken() throws IllegalStateException, NoSuchElementException {
        if (this.currentToken == null) {
            if (this.completed) {
                if (this.tokens.isEmpty()) {
                    throw new NoSuchElementException(CommonI18n.noMoreContent.text(new Object[0]));
                }
                return this.tokens.get(this.tokens.size() - 1);
            }
            throw new IllegalStateException(CommonI18n.startMethodMustBeCalledBeforeConsumingOrMatching.text(new Object[0]));
        }
        if (this.tokenIterator.previousIndex() == 0) {
            throw new NoSuchElementException(CommonI18n.noMoreContent.text(new Object[0]));
        }
        return this.tokens.get(this.tokenIterator.previousIndex() - 1);
    }

    String generateFragment() {
        assert (this.currentToken != null);
        int startIndex = this.currentToken.startIndex();
        return TokenStream.generateFragment(this.inputString, startIndex, 20, " ===>> ");
    }

    static String generateFragment(String content, int indexOfProblem, int charactersToIncludeBeforeAndAfter, String highlightText) {
        assert (content != null);
        assert (indexOfProblem < content.length());
        int beforeStart = Math.max(0, indexOfProblem - charactersToIncludeBeforeAndAfter);
        String before = content.substring(beforeStart, indexOfProblem);
        int afterEnd = Math.min(indexOfProblem + charactersToIncludeBeforeAndAfter, content.length());
        String after = content.substring(indexOfProblem, afterEnd);
        return before + (highlightText != null ? highlightText : "") + after;
    }

    public static BasicTokenizer basicTokenizer(boolean includeComments) {
        return new BasicTokenizer(includeComments);
    }

    public static class BasicTokenizer
    implements Tokenizer {
        public static final int WORD = 1;
        public static final int SYMBOL = 2;
        public static final int DECIMAL = 4;
        public static final int SINGLE_QUOTED_STRING = 8;
        public static final int DOUBLE_QUOTED_STRING = 16;
        public static final int COMMENT = 32;
        private final boolean useComments;

        protected BasicTokenizer(boolean useComments) {
            this.useComments = useComments;
        }

        public void tokenize(CharacterStream input, Tokens tokens) throws ParsingException {
            block8: while (input.hasNext()) {
                char c = input.next();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '!': 
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '|': 
                    case '}': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    case '.': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 4);
                        break;
                    }
                    case '\"': {
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext('\"')) {
                                c = input.next();
                                continue;
                            }
                            if (c != '\"') continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingDoubleQuoteFound.text(startingPosition.getLine(), startingPosition.getColumn());
                            throw new ParsingException(startingPosition, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 16);
                        break;
                    }
                    case '\'': {
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext('\'')) {
                                c = input.next();
                                continue;
                            }
                            if (c != '\'') continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingSingleQuoteFound.text(startingPosition.getLine(), startingPosition.getColumn());
                            throw new ParsingException(startingPosition, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 8);
                        break;
                    }
                    case '/': {
                        int endIndex;
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        if (input.isNext('/')) {
                            boolean foundLineTerminator = false;
                            while (input.hasNext()) {
                                c = input.next();
                                if (c != '\n' && c != '\r') continue;
                                foundLineTerminator = true;
                                break;
                            }
                            endIndex = input.index();
                            if (!foundLineTerminator) {
                                ++endIndex;
                            }
                            if (c == '\r' && input.isNext('\n')) {
                                input.next();
                            }
                            if (!this.useComments) continue block8;
                            tokens.addToken(startingPosition, startIndex, endIndex, 32);
                            break;
                        }
                        if (input.isNext('*')) {
                            while (input.hasNext() && !input.isNext('*', '/')) {
                                c = input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (!this.useComments) continue block8;
                            endIndex = input.index() + 1;
                            tokens.addToken(startingPosition, startIndex, endIndex, 32);
                            break;
                        }
                        tokens.addToken(startingPosition, startIndex, startIndex + 1, 2);
                        break;
                    }
                    default: {
                        int startIndex = input.index();
                        Position startingPosition = input.position(startIndex);
                        while (input.hasNext() && !input.isNextWhitespace() && !input.isNextAnyOf("/.-(){}*,;+%?$[]!<>|=:")) {
                            c = input.next();
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 1);
                    }
                }
            }
        }
    }

    public static final class CharacterArrayStream
    implements CharacterStream {
        private final char[] content;
        private int lastIndex = -1;
        private final int maxIndex;
        private int lineNumber = 1;
        private int columnNumber = 0;
        private boolean nextCharMayBeLineFeed;

        public CharacterArrayStream(char[] content) {
            this.content = content;
            this.maxIndex = content.length - 1;
        }

        public boolean hasNext() {
            return this.lastIndex < this.maxIndex;
        }

        public int index() {
            return this.lastIndex;
        }

        public Position position(int startIndex) {
            return new Position(startIndex, this.lineNumber, this.columnNumber);
        }

        public char next() {
            if (this.lastIndex >= this.maxIndex) {
                throw new NoSuchElementException();
            }
            char result = this.content[++this.lastIndex];
            ++this.columnNumber;
            if (result == '\r') {
                this.nextCharMayBeLineFeed = true;
                ++this.lineNumber;
                this.columnNumber = 0;
            } else if (result == '\n') {
                if (!this.nextCharMayBeLineFeed) {
                    ++this.lineNumber;
                }
                this.columnNumber = 0;
            } else if (this.nextCharMayBeLineFeed) {
                this.nextCharMayBeLineFeed = false;
            }
            return result;
        }

        public boolean isNext(char c) {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && this.content[nextIndex] == c;
        }

        public boolean isNext(char nextChar1, char nextChar2) {
            int nextIndex1 = this.lastIndex + 1;
            int nextIndex2 = this.lastIndex + 2;
            return nextIndex2 <= this.maxIndex && this.content[nextIndex1] == nextChar1 && this.content[nextIndex2] == nextChar2;
        }

        public boolean isNext(char nextChar1, char nextChar2, char nextChar3) {
            int nextIndex1 = this.lastIndex + 1;
            int nextIndex2 = this.lastIndex + 2;
            int nextIndex3 = this.lastIndex + 3;
            return nextIndex3 <= this.maxIndex && this.content[nextIndex1] == nextChar1 && this.content[nextIndex2] == nextChar2 && this.content[nextIndex3] == nextChar3;
        }

        public boolean isNextAnyOf(char[] characters) {
            int nextIndex = this.lastIndex + 1;
            if (nextIndex <= this.maxIndex) {
                char nextChar = this.content[this.lastIndex + 1];
                for (char c : characters) {
                    if (c != nextChar) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isNextAnyOf(String characters) {
            char nextChar;
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && characters.indexOf(nextChar = this.content[this.lastIndex + 1]) != -1;
        }

        public boolean isNextWhitespace() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && Character.isWhitespace(this.content[nextIndex]);
        }

        public boolean isNextLetterOrDigit() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && Character.isLetterOrDigit(this.content[nextIndex]);
        }

        public boolean isNextValidXmlCharacter() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && XmlCharacters.isValid(this.content[nextIndex]);
        }

        public boolean isNextValidXmlNameCharacter() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && XmlCharacters.isValidName(this.content[nextIndex]);
        }

        public boolean isNextValidXmlNcNameCharacter() {
            int nextIndex = this.lastIndex + 1;
            return nextIndex <= this.maxIndex && XmlCharacters.isValidNcName(this.content[nextIndex]);
        }
    }

    public class CaseInsensitiveTokenFactory
    extends TokenFactory {
        public void addToken(Position position, int startIndex, int endIndex, int type) {
            this.tokens.add(new CaseInsensitiveToken(startIndex, endIndex, type, position));
        }
    }

    public class CaseSensitiveTokenFactory
    extends TokenFactory {
        public void addToken(Position position, int startIndex, int endIndex, int type) {
            this.tokens.add(new CaseSensitiveToken(startIndex, endIndex, type, position));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class TokenFactory
    implements Tokens {
        protected final List<Token> tokens = new ArrayList<Token>();

        protected TokenFactory() {
        }

        @Override
        public void addToken(Position position, int index) {
            this.addToken(position, index, index + 1, 0);
        }

        @Override
        public final void addToken(Position position, int startIndex, int endIndex) {
            this.addToken(position, startIndex, endIndex, 0);
        }

        public List<Token> getTokens() {
            return this.tokens;
        }
    }

    @Immutable
    protected class CaseInsensitiveToken
    extends CaseSensitiveToken {
        public CaseInsensitiveToken(int startIndex, int endIndex, int type, Position position) {
            super(startIndex, endIndex, type, position);
        }

        protected String matchString() {
            return TokenStream.this.inputUppercased;
        }

        public Token withType(int typeMask) {
            int type = this.type() | typeMask;
            return new CaseInsensitiveToken(this.startIndex(), this.endIndex(), type, this.position());
        }
    }

    @Immutable
    protected class CaseSensitiveToken
    implements Token {
        private final int startIndex;
        private final int endIndex;
        private final int type;
        private final Position position;

        public CaseSensitiveToken(int startIndex, int endIndex, int type, Position position) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.type = type;
            this.position = position;
        }

        public Token withType(int typeMask) {
            int type = this.type | typeMask;
            return new CaseSensitiveToken(this.startIndex, this.endIndex, type, this.position);
        }

        public final int type() {
            return this.type;
        }

        public final int startIndex() {
            return this.startIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        public final int length() {
            return this.endIndex - this.startIndex;
        }

        public final boolean matches(char expected) {
            return this.length() == 1 && this.matchString().charAt(this.startIndex) == expected;
        }

        public final boolean matches(String expected) {
            return this.matchString().substring(this.startIndex, this.endIndex).equals(expected);
        }

        public final boolean matches(int expectedType) {
            return expectedType == Integer.MIN_VALUE || (TokenStream.this.currentToken().type() & expectedType) == expectedType;
        }

        public final String value() {
            return TokenStream.this.inputString.substring(this.startIndex, this.endIndex);
        }

        public Position position() {
            return this.position;
        }

        protected String matchString() {
            return TokenStream.this.inputString;
        }

        public String toString() {
            return this.value();
        }
    }

    @Immutable
    public static interface Token {
        public String value();

        public boolean matches(String var1);

        public boolean matches(char var1);

        public boolean matches(int var1);

        public int type();

        public int startIndex();

        public int endIndex();

        public int length();

        public Position position();

        public Token withType(int var1);
    }

    public static interface Tokens {
        public void addToken(Position var1, int var2);

        public void addToken(Position var1, int var2, int var3);

        public void addToken(Position var1, int var2, int var3, int var4);
    }

    public static interface CharacterStream {
        public boolean hasNext();

        public char next();

        public int index();

        public Position position(int var1);

        public boolean isNextWhitespace();

        public boolean isNextLetterOrDigit();

        public boolean isNextValidXmlCharacter();

        public boolean isNextValidXmlNameCharacter();

        public boolean isNextValidXmlNcNameCharacter();

        public boolean isNext(char var1);

        public boolean isNext(char var1, char var2);

        public boolean isNext(char var1, char var2, char var3);

        public boolean isNextAnyOf(char[] var1);

        public boolean isNextAnyOf(String var1);
    }

    public static interface Tokenizer {
        public void tokenize(CharacterStream var1, Tokens var2) throws ParsingException;
    }
}

