/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Reflection {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] BRACKETS_PAIR = new String[]{"", "[]", "[][]", "[][][]", "[][][][]", "[][][][][]"};
    private final Class<?> targetClass;
    private Map<String, LinkedList<Method>> methodMap = null;

    public static Class<?>[] buildArgumentClasses(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[arguments.length];
        int i = 0;
        for (Object argument : arguments) {
            result[i] = argument != null ? argument.getClass() : null;
        }
        return result;
    }

    public static List<Class<?>> buildArgumentClassList(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(arguments.length);
        for (Object argument : arguments) {
            if (argument != null) {
                result.add(argument.getClass());
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static List<Class<?>> convertArgumentClassesToPrimitives(Class<?> ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(arguments.length);
        for (Class<Object> clazz : arguments) {
            if (clazz == Boolean.class) {
                clazz = Boolean.TYPE;
            } else if (clazz == Character.class) {
                clazz = Character.TYPE;
            } else if (clazz == Byte.class) {
                clazz = Byte.TYPE;
            } else if (clazz == Short.class) {
                clazz = Short.TYPE;
            } else if (clazz == Integer.class) {
                clazz = Integer.TYPE;
            } else if (clazz == Long.class) {
                clazz = Long.TYPE;
            } else if (clazz == Float.class) {
                clazz = Float.TYPE;
            } else if (clazz == Double.class) {
                clazz = Double.TYPE;
            } else if (clazz == Void.class) {
                clazz = Void.TYPE;
            }
            result.add(clazz);
        }
        return result;
    }

    public static String getClassName(Class<?> clazz) {
        String fullName = clazz.getName();
        int fullNameLength = fullName.length();
        for (int numArrayDimensions = 0; numArrayDimensions < fullNameLength; ++numArrayDimensions) {
            char c = fullName.charAt(numArrayDimensions);
            if (c == '[') continue;
            String name = null;
            switch (c) {
                case 'L': {
                    name = ((Object)fullName.subSequence(numArrayDimensions + 1, fullNameLength)).toString();
                    break;
                }
                case 'B': {
                    name = "byte";
                    break;
                }
                case 'C': {
                    name = "char";
                    break;
                }
                case 'D': {
                    name = "double";
                    break;
                }
                case 'F': {
                    name = "float";
                    break;
                }
                case 'I': {
                    name = "int";
                    break;
                }
                case 'J': {
                    name = "long";
                    break;
                }
                case 'S': {
                    name = "short";
                    break;
                }
                case 'Z': {
                    name = "boolean";
                    break;
                }
                case 'V': {
                    name = "void";
                    break;
                }
                default: {
                    name = ((Object)fullName.subSequence(numArrayDimensions, fullNameLength)).toString();
                }
            }
            if (numArrayDimensions == 0) {
                return name;
            }
            if (numArrayDimensions < BRACKETS_PAIR.length) {
                name = name + BRACKETS_PAIR[numArrayDimensions];
            } else {
                for (int i = 0; i < numArrayDimensions; ++i) {
                    name = name + BRACKETS_PAIR[1];
                }
            }
            return name;
        }
        return fullName;
    }

    public Reflection(Class<?> targetClass) {
        CheckArg.isNotNull(targetClass, "targetClass");
        this.targetClass = targetClass;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Method[] findMethods(String methodName, boolean caseSensitive) {
        Pattern pattern = caseSensitive ? Pattern.compile(methodName) : Pattern.compile(methodName, 2);
        return this.findMethods(pattern);
    }

    public Method[] findMethods(Pattern methodNamePattern) {
        Method[] allMethods = this.targetClass.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!methodNamePattern.matcher(m.getName()).matches()) continue;
            result.add(m);
        }
        return result.toArray(new Method[result.size()]);
    }

    public Method[] findGetterMethods() {
        Method[] allMethods = this.targetClass.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            String name;
            Method m = allMethods[i];
            int numParams = m.getParameterTypes().length;
            if (numParams != 0 || (name = m.getName()).equals("getClass") || m.getReturnType() == Void.TYPE || !name.startsWith("get") && !name.startsWith("is")) continue;
            result.add(m);
        }
        return result.toArray(new Method[result.size()]);
    }

    public String[] findGetterPropertyNames() {
        Method[] getters = this.findGetterMethods();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < getters.length; ++i) {
            Method m = getters[i];
            String name = m.getName();
            if (name.startsWith("get") && name.length() > 3) {
                result.add(name.substring(3));
                continue;
            }
            if (!name.startsWith("is") || name.length() <= 2) continue;
            result.add(name.substring(2));
        }
        return result.toArray(new String[result.size()]);
    }

    public Method findFirstMethod(String methodName, boolean caseSensitive) {
        Pattern pattern = caseSensitive ? Pattern.compile(methodName) : Pattern.compile(methodName, 2);
        return this.findFirstMethod(pattern);
    }

    public Method findFirstMethod(Pattern methodNamePattern) {
        Method[] allMethods = this.targetClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!methodNamePattern.matcher(m.getName()).matches()) continue;
            return m;
        }
        return null;
    }

    public Object invokeBestMethodOnTarget(String[] methodNames, Object target, Object ... arguments) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?>[] argumentClasses = Reflection.buildArgumentClasses(arguments);
        int remaining = methodNames.length;
        Object result = null;
        for (String methodName : methodNames) {
            --remaining;
            try {
                Method method = this.findBestMethodWithSignature(methodName, argumentClasses);
                result = method.invoke(target, arguments);
                break;
            }
            catch (NoSuchMethodException e) {
                if (remaining != 0) continue;
                throw e;
            }
        }
        return result;
    }

    public Object invokeSetterMethodOnTarget(String javaPropertyName, Object target, Object argument) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] methodNamesArray = this.findMethodNames("set" + javaPropertyName);
        return this.invokeBestMethodOnTarget(methodNamesArray, target, argument);
    }

    public Object invokeGetterMethodOnTarget(String javaPropertyName, Object target) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] methodNamesArray = this.findMethodNames("get" + javaPropertyName);
        return this.invokeBestMethodOnTarget(methodNamesArray, target, new Object[0]);
    }

    protected String[] findMethodNames(String methodName) {
        Method[] methods = this.findMethods(methodName, false);
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methods) {
            String actualMethodName = method.getName();
            methodNames.add(actualMethodName);
        }
        return methodNames.toArray(new String[methodNames.size()]);
    }

    public Method findBestMethodOnTarget(String methodName, Object ... arguments) throws NoSuchMethodException, SecurityException {
        Class<?>[] argumentClasses = Reflection.buildArgumentClasses(arguments);
        return this.findBestMethodWithSignature(methodName, argumentClasses);
    }

    public Method findBestMethodWithSignature(String methodName, Class<?> ... argumentsClasses) throws NoSuchMethodException, SecurityException {
        Class<?>[] classArgs = null;
        try {
            classArgs = argumentsClasses != null ? argumentsClasses : new Class[]{};
            Method result = this.targetClass.getMethod(methodName, classArgs);
            return result;
        }
        catch (NoSuchMethodException e) {
            List<Class<?>> argumentsClassList = Reflection.convertArgumentClassesToPrimitives(argumentsClasses);
            try {
                classArgs = argumentsClassList.toArray(new Class[argumentsClassList.size()]);
                Method result = this.targetClass.getMethod(methodName, classArgs);
                return result;
            }
            catch (NoSuchMethodException e2) {
                LinkedList<Method> methodsWithSameName;
                if (this.methodMap == null) {
                    this.methodMap = new HashMap<String, LinkedList<Method>>();
                    Method[] methods = this.targetClass.getMethods();
                    for (int i = 0; i != methods.length; ++i) {
                        Method method = methods[i];
                        methodsWithSameName = this.methodMap.get(method.getName());
                        if (methodsWithSameName == null) {
                            methodsWithSameName = new LinkedList();
                            this.methodMap.put(method.getName(), methodsWithSameName);
                        }
                        methodsWithSameName.addFirst(method);
                    }
                }
                for (int j = 0; j != 2; ++j) {
                    methodsWithSameName = this.methodMap.get(methodName);
                    if (methodsWithSameName == null) {
                        throw new NoSuchMethodException(methodName);
                    }
                    for (Method method : methodsWithSameName) {
                        Class<?>[] args = method.getParameterTypes();
                        if (args.length != argumentsClassList.size()) continue;
                        boolean allMatch = true;
                        for (int i = 0; i < args.length; ++i) {
                            Class<?> clazz = argumentsClassList.get(i);
                            if (clazz != null) {
                                if (args[i].isAssignableFrom(clazz)) continue;
                                allMatch = false;
                                i = args.length;
                                continue;
                            }
                            if (!args[i].isPrimitive()) continue;
                            allMatch = false;
                            i = args.length;
                        }
                        if (!allMatch) continue;
                        return method;
                    }
                }
                throw new NoSuchMethodException(methodName);
            }
        }
    }
}

